/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.pipes.functions;

import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ai.pipes.services.JacksonUtil;
import org.nuxeo.ai.pipes.services.PipelineService;
import org.nuxeo.ai.pipes.types.BlobTextFromDocument;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.kv.KeyValueStore;

public class BinaryTextListener
implements EventListener {
    public static final String BINARY_TEXT_STREAM_KV = "BINARY_TEXT_STREAM";
    private static final Log log = LogFactory.getLog(BinaryTextListener.class);
    protected final String binaryProperty;
    protected final String consumerName;
    protected final int timeout;
    protected final boolean useWindow;

    public BinaryTextListener(String consumerName, String binaryProperty, int windowSizeSeconds) {
        this.binaryProperty = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{binaryProperty}) ? binaryProperty : "fulltextBinary";
        this.consumerName = consumerName;
        this.timeout = windowSizeSeconds;
        this.useWindow = this.timeout > 0;
    }

    public void handleEvent(Event event) {
        DocumentModel doc = JacksonUtil.toDoc(event);
        Boolean hasText = (Boolean)event.getContext().getProperty(this.binaryProperty);
        if (doc != null && hasText != null && hasText.booleanValue()) {
            if (this.useWindow) {
                KeyValueStore kvStore = ((KeyValueService)Framework.getService(KeyValueService.class)).getKeyValueStore(BINARY_TEXT_STREAM_KV);
                byte[] existing = kvStore.get(doc.getId());
                if (existing == null) {
                    this.handleBinaryText(doc, event.getContext());
                    kvStore.put(doc.getId(), "", (long)this.timeout);
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Skipping because there is already an event for " + doc.getId()));
                }
            } else {
                this.handleBinaryText(doc, event.getContext());
            }
        }
    }

    protected void handleBinaryText(DocumentModel doc, EventContext context) {
        String text;
        Consumer<Record> consumer;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Handling new binary text for doc " + doc.getId()));
        }
        if ((consumer = ((PipelineService)Framework.getService(PipelineService.class)).getConsumer(this.consumerName)) != null && StringUtils.isNotBlank((CharSequence)(text = (String)((Object)context.getProperty("systemPropertyValue"))))) {
            BlobTextFromDocument blobTextFromDoc = new BlobTextFromDocument(doc);
            blobTextFromDoc.addProperty(this.binaryProperty, text);
            consumer.accept(JacksonUtil.toRecord(blobTextFromDoc.getKey(), blobTextFromDoc));
        }
    }
}

