/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.pipes.services;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.util.Converter;
import com.fasterxml.jackson.databind.util.StdConverter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Instant;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobMetaImpl;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.lib.stream.computation.Record;

public class JacksonUtil {
    public static final ObjectMapper MAPPER = new ObjectMapper();

    public static String toJsonString(JsonGeneratorConsumer withConsumer) {
        StringWriter writer = new StringWriter();
        try (JsonGenerator jg = MAPPER.getFactory().createGenerator((Writer)writer);){
            jg.writeStartObject();
            if (withConsumer != null) {
                withConsumer.accept(jg);
            }
            jg.writeEndObject();
        }
        catch (IOException e) {
            throw new NuxeoException("Unable to turn data into a json String", (Throwable)e);
        }
        return writer.toString();
    }

    public static DocumentModel toDoc(Event event) {
        DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
        if (docCtx == null) {
            return null;
        }
        DocumentModel doc = docCtx.getSourceDocument();
        if (doc == null) {
            return null;
        }
        return doc;
    }

    public static Record toRecord(String key, Object info) {
        try {
            return Record.of((String)key, (byte[])MAPPER.writeValueAsBytes(info));
        }
        catch (JsonProcessingException e) {
            throw new NuxeoException("Unable to serialize properties for: " + key, (Throwable)e);
        }
    }

    public static <T> T fromRecord(Record record, Class<T> valueType) {
        try {
            return (T)MAPPER.readValue(record.getData(), valueType);
        }
        catch (IOException e) {
            throw new NuxeoException("Unable to read record data for : " + record.getKey(), (Throwable)e);
        }
    }

    static {
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Instant.class, (JsonDeserializer)new InstantDeserializer());
        module.addSerializer(Instant.class, (JsonSerializer)new InstantSerializer());
        module.addSerializer(ManagedBlob.class, (JsonSerializer)new ManagedBlobSerializer());
        module.addDeserializer(ManagedBlob.class, (JsonDeserializer)new StdDelegatingDeserializer((Converter)new StdConverter<BlobMetaImpl, ManagedBlob>(){

            public ManagedBlob convert(BlobMetaImpl value) {
                return value;
            }
        }));
        MAPPER.registerModule((Module)module);
    }

    public static class InstantDeserializer
    extends JsonDeserializer<Instant> {
        public Instant deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            String val = (String)ctxt.readValue(jp, String.class);
            return Instant.parse(val);
        }
    }

    public static class ManagedBlobSerializer
    extends JsonSerializer<ManagedBlob> {
        public void serialize(ManagedBlob blob, JsonGenerator jg, SerializerProvider serializers) throws IOException {
            jg.writeStartObject();
            jg.writeStringField("mimeType", blob.getMimeType());
            jg.writeStringField("encoding", blob.getEncoding());
            jg.writeStringField("digest", blob.getDigest());
            jg.writeStringField("providerId", blob.getProviderId());
            jg.writeStringField("key", blob.getKey());
            jg.writeNumberField("length", blob.getLength());
            jg.writeEndObject();
        }
    }

    public static class InstantSerializer
    extends JsonSerializer<Instant> {
        public void serialize(Instant instant, JsonGenerator jg, SerializerProvider serializers) throws IOException {
            jg.writeObject((Object)instant.toString());
        }
    }

    @FunctionalInterface
    public static interface JsonGeneratorConsumer {
        public void accept(JsonGenerator var1) throws IOException;
    }
}

