/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.pipes.consumers;

import java.io.Externalizable;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.log.LogAppender;
import org.nuxeo.lib.stream.log.internals.CloseableLogAppender;

public class LogAppenderConsumer
implements Consumer<Record>,
AutoCloseable {
    private static final Log log = LogFactory.getLog(LogAppenderConsumer.class);
    private final CloseableLogAppender<Record> appender;

    public LogAppenderConsumer(CloseableLogAppender<Record> appender) {
        this.appender = appender;
    }

    @Override
    public void accept(Record record) {
        if (record != null) {
            this.getAppender().append(record.getKey(), (Externalizable)record);
        }
    }

    protected LogAppender<Record> getAppender() {
        if (this.appender.closed()) {
            log.warn((Object)("We can't append to a closed appender. " + this.appender.name()));
        }
        return this.appender;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LogAppenderConsumer{");
        sb.append("appender=").append(this.appender);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void close() {
        if (this.appender != null) {
            this.appender.close();
        }
    }
}

