/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.pipes.filters;

import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.nuxeo.ai.pipes.filters.PropertyFilter;
import org.nuxeo.ecm.core.api.Blob;

public class MimeBlobPropertyFilter
extends PropertyFilter.BlobPropertyFilter {
    protected Predicate<String> mimeRegex;

    @Override
    public void init(Map<String, String> options) {
        super.init(options);
        this.mimeRegex = Pattern.compile(options.get("mimePattern")).asPredicate();
    }

    @Override
    public boolean testBlob(Blob blob) {
        String mimeType = blob.getMimeType();
        return mimeType != null && this.mimeRegex.test(mimeType);
    }
}

