/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.pipes.filters;

import java.util.List;
import java.util.Map;
import org.nuxeo.ai.pipes.filters.Filter;
import org.nuxeo.ai.pipes.streams.Initializable;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;

public abstract class PropertyFilter
implements Filter.DocumentFilter,
Initializable {
    protected List<String> properties;

    @Override
    public void init(Map<String, String> options) {
        this.properties = this.propsList(options.get("properties"));
    }

    @Override
    public boolean test(DocumentModel documentModel) {
        return documentModel != null && this.properties.stream().anyMatch(prop -> this.testProperty(documentModel, (String)prop));
    }

    public boolean testProperty(DocumentModel documentModel, String xPath) {
        try {
            Property property = documentModel.getProperty(xPath);
            return this.testProperty(property);
        }
        catch (PropertyNotFoundException e) {
            return false;
        }
    }

    public abstract boolean testProperty(Property var1);

    public static abstract class BlobPropertyFilter
    extends PropertyFilter {
        @Override
        public boolean testProperty(Property property) {
            try {
                Blob blob = (Blob)property.getValue();
                if (blob != null) {
                    return this.testBlob(blob);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return false;
        }

        public abstract boolean testBlob(Blob var1);
    }
}

