/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.pipes.services;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuxeo.ai.pipes.filters.DirtyPropertyFilter;
import org.nuxeo.ai.pipes.filters.DocumentEventFilter;
import org.nuxeo.ai.pipes.filters.Filter;
import org.nuxeo.ai.pipes.functions.PreFilterFunction;
import org.nuxeo.ai.pipes.functions.PropertiesToStream;
import org.nuxeo.ai.pipes.streams.Initializable;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.stream.LogConfigDescriptor;

@XObject(value="pipe")
public class PipeDescriptor {
    public static final Class<? extends Function> DEFAULT_TRANSFORMER = PropertiesToStream.class;
    @XNode(value="@id")
    public String id;
    @XNode(value="@enabled")
    protected boolean enabled = true;
    @XNode(value="@async")
    protected Boolean isAsync = true;
    @XNode(value="supplier")
    protected Supplier supplier;
    @XNode(value="consumer")
    protected Consumer consumer;
    @XNode(value="transformer")
    protected TransformingFunction transformer;

    public void validate() {
        StringBuilder errors = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)this.id)) {
            errors.append("You must specify an id\n");
        }
        if (this.transformer == null) {
            errors.append("You must specify a transformer\n");
        }
        if (this.supplier == null || this.supplier.events == null || this.supplier.events.isEmpty()) {
            errors.append("Invalid supplier configuration, you must specify an event\n");
        }
        if (this.consumer == null || this.consumer.streams == null || this.consumer.streams.isEmpty()) {
            errors.append("Invalid consumer configuration, you must specify at least consumer\n");
        }
        if (errors.length() > 0) {
            throw new NuxeoException(errors.toString());
        }
    }

    public void merge(PipeDescriptor other) {
        if (!this.id.equals(other.id)) {
            return;
        }
        if (other.enabled != this.enabled) {
            this.enabled = other.enabled;
        }
        if (other.transformer != null) {
            this.transformer.options.putAll(other.transformer.options);
            if (other.transformer.function != null) {
                this.transformer.function = other.transformer.function;
            }
        }
        if (other.supplier != null && other.supplier.events != null && !other.supplier.events.isEmpty()) {
            this.supplier.events = other.supplier.events;
        }
        if (other.consumer != null && other.consumer.streams != null && !other.consumer.streams.isEmpty()) {
            this.consumer.streams = other.consumer.streams;
        }
    }

    public Function<Event, Collection<Record>> getFunction(PipeEvent event) {
        try {
            Function func;
            if (this.transformer.function == null) {
                this.transformer.function = DEFAULT_TRANSFORMER;
            }
            if ((func = this.transformer.function.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])) instanceof Initializable) {
                ((Initializable)((Object)func)).init(this.transformer.options);
            }
            if (func instanceof PreFilterFunction) {
                ((PreFilterFunction)func).setFilter(this.getEventFilter(event));
            }
            return func;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new NuxeoException(String.format("PipeDescriptor %s must define a valid transformer function", this.id), (Throwable)e);
        }
    }

    public boolean hasDirtyCheckFilter(PipeEvent event) {
        return event.filters.stream().anyMatch(pipeFilter -> DirtyPropertyFilter.class.isAssignableFrom(pipeFilter.clazz));
    }

    public Filter<Event> getEventFilter(PipeEvent event) {
        if (event != null) {
            try {
                DocumentEventFilter.Builder builder = new DocumentEventFilter.Builder();
                for (PipeFilter filter : event.filters) {
                    Filter theFilter = filter.clazz.newInstance();
                    if (theFilter instanceof Initializable) {
                        filter.options.putAll(event.options);
                        ((Initializable)((Object)theFilter)).init(filter.options);
                    }
                    if (theFilter instanceof Filter.DocumentFilter) {
                        builder.withDocumentFilter((Filter.DocumentFilter)theFilter);
                        continue;
                    }
                    builder.withEventFilter((Filter.EventFilter)theFilter);
                }
                return builder.build();
            }
            catch (ClassCastException | IllegalAccessException | InstantiationException e) {
                throw new NuxeoException("PipeDescriptor must define valid event filters", (Throwable)e);
            }
        }
        return null;
    }

    @XObject(value="transformer")
    public static class TransformingFunction {
        @XNodeMap(value="option", key="@name", type=HashMap.class, componentType=String.class)
        public Map<String, String> options = new HashMap<String, String>();
        @XNode(value="@class")
        protected Class<? extends Function> function;
    }

    @XObject(value="consumer")
    public static class Consumer {
        @XNodeList(value="stream", type=ArrayList.class, componentType=LogConfigDescriptor.StreamDescriptor.class)
        public List<LogConfigDescriptor.StreamDescriptor> streams = new ArrayList<LogConfigDescriptor.StreamDescriptor>(0);
    }

    @XObject(value="filter")
    public static class PipeFilter {
        @XNodeMap(value="option", key="@name", type=HashMap.class, componentType=String.class)
        public Map<String, String> options = new HashMap<String, String>();
        @XNode(value="@class")
        protected Class<? extends Filter.EventFilter> clazz;

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    @XObject(value="event")
    public static class PipeEvent {
        @XNode(value="@name")
        public String name;
        @XNodeMap(value="option", key="@name", type=HashMap.class, componentType=String.class)
        public Map<String, String> options = new HashMap<String, String>();
        @XNodeList(value="filter", type=ArrayList.class, componentType=PipeFilter.class)
        public List<PipeFilter> filters = new ArrayList<PipeFilter>(0);

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    @XObject(value="supplier")
    public static class Supplier {
        @XNodeList(value="event", type=ArrayList.class, componentType=PipeEvent.class)
        public List<PipeEvent> events = new ArrayList<PipeEvent>(0);
    }
}

