/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.pipes.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuxeo.ai.pipes.types.Partitionable;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.blob.ManagedBlob;

public class BlobTextFromDocument
implements Partitionable {
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Map<String, ManagedBlob> blobs = new HashMap<String, ManagedBlob>();
    private String id;
    private String repositoryName;
    private String parentId;
    private String primaryType;
    private Set<String> facets;

    public BlobTextFromDocument() {
    }

    public BlobTextFromDocument(String id, String repositoryName, String parentId, String primaryType, Set<String> facets) {
        this.id = id;
        this.repositoryName = repositoryName;
        this.parentId = parentId;
        this.primaryType = primaryType;
        this.facets = facets;
    }

    public BlobTextFromDocument(DocumentModel doc) {
        this.id = doc.getId();
        this.repositoryName = doc.getRepositoryName();
        this.parentId = doc.getParentRef().toString();
        this.primaryType = doc.getType();
        this.facets = doc.getFacets();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public void setPrimaryType(String primaryType) {
        this.primaryType = primaryType;
    }

    public Set<String> getFacets() {
        return this.facets;
    }

    public void setFacets(Set<String> facets) {
        this.facets = facets;
    }

    public Map<String, ManagedBlob> getBlobs() {
        return this.blobs;
    }

    public void addBlob(String name, ManagedBlob blob) {
        this.blobs.put(name, blob);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void addProperty(String name, String propVal) {
        this.properties.put(name, propVal);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlobTextFromDocument that = (BlobTextFromDocument)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.repositoryName, that.repositoryName) && Objects.equals(this.parentId, that.parentId) && Objects.equals(this.primaryType, that.primaryType) && Objects.equals(this.facets, that.facets) && Objects.equals(this.blobs, that.blobs) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.repositoryName, this.parentId, this.primaryType, this.facets, this.blobs, this.properties);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("repositoryName", (Object)this.repositoryName).append("parentId", (Object)this.parentId).append("primaryType", (Object)this.primaryType).append("facets", this.facets).append("blob", this.blobs).append("properties", this.properties).toString();
    }

    @Override
    @JsonIgnore
    public String getKey() {
        return this.getId();
    }
}

