/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.AbstractBlob;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.runtime.api.Framework;

public class BlobMetaImpl
extends AbstractBlob
implements ManagedBlob {
    private static final long serialVersionUID = -3811624887207152594L;
    protected final String providerId;
    protected final String key;
    protected final Long length;

    @JsonCreator
    public BlobMetaImpl(@JsonProperty(value="providerId") String providerId, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="key") String key, @JsonProperty(value="digest") String digest, @JsonProperty(value="encoding") String encoding, @JsonProperty(value="length") long length) {
        this.providerId = providerId;
        this.mimeType = mimeType;
        this.key = key;
        this.digest = digest;
        this.encoding = encoding;
        this.length = length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BlobMetaImpl blobInfo = (BlobMetaImpl)((Object)o);
        return Objects.equals(this.key, blobInfo.key) && Objects.equals(this.mimeType, blobInfo.mimeType) && Objects.equals(this.encoding, blobInfo.encoding) && Objects.equals(this.filename, blobInfo.filename) && Objects.equals(this.length, blobInfo.length) && Objects.equals(this.providerId, blobInfo.providerId) && Objects.equals(this.digest, blobInfo.digest);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.mimeType, this.encoding, this.filename, this.length, this.digest, this.providerId);
    }

    public String getProviderId() {
        return this.providerId;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getKey() {
        return this.key;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getDigest() {
        return this.digest;
    }

    public InputStream getStream() throws IOException {
        BlobProvider blobProvider = ((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(this.getProviderId());
        if (blobProvider != null) {
            BlobInfo blobInfo = new BlobInfo();
            blobInfo.key = this.getKey();
            Blob blob = blobProvider.readBlob(blobInfo);
            if (blob != null) {
                return blob.getStream();
            }
        }
        throw new IOException("Unable to read blob: " + (Object)((Object)this));
    }

    public long getLength() {
        return this.length;
    }
}

