/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.pipes.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ai.pipes.functions.PropertyUtils;
import org.nuxeo.ai.pipes.services.JacksonUtil;
import org.nuxeo.ai.pipes.types.BlobTextFromDocument;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.event.Event;

public class DocEventToStream
implements Function<Event, Collection<BlobTextFromDocument>> {
    public static final String BLOB_PROPERTIES = "blobProperties";
    public static final String TEXT_PROPERTIES = "textProperties";
    public static final String CUSTOM_PROPERTIES = "customProperties";
    protected static final List<String> DEFAULT_BLOB_PROPERTIES = Collections.singletonList("file:content");
    private static final Log log = LogFactory.getLog(DocEventToStream.class);
    protected final List<String> blobProperties;
    protected final List<String> textProperties;
    protected final List<String> customProperties;

    public DocEventToStream() {
        this(DEFAULT_BLOB_PROPERTIES, null, null);
    }

    public DocEventToStream(List<String> blobProperties, List<String> textProperties, List<String> customProperties) {
        this.blobProperties = blobProperties != null ? blobProperties : Collections.emptyList();
        this.textProperties = textProperties != null ? textProperties : Collections.emptyList();
        List<String> list = this.customProperties = customProperties != null ? customProperties : Collections.emptyList();
        if (this.blobProperties.isEmpty() && this.textProperties.isEmpty() && this.customProperties.isEmpty()) {
            throw new IllegalArgumentException("DocEventToStream requires at least one property name.");
        }
    }

    @Override
    public Collection<BlobTextFromDocument> apply(Event event) {
        DocumentModel doc = JacksonUtil.toDoc(event);
        if (doc != null) {
            try {
                return this.docSerialize(doc);
            }
            catch (PropertyException e) {
                log.error((Object)"Unable to serialize event document", (Throwable)e);
                throw e;
            }
        }
        return Collections.emptyList();
    }

    public Collection<BlobTextFromDocument> docSerialize(DocumentModel doc) {
        ArrayList<BlobTextFromDocument> items = new ArrayList<BlobTextFromDocument>();
        this.blobProperties.forEach(propName -> {
            Blob blob = PropertyUtils.getPropertyValue(doc, propName, Blob.class);
            if (blob instanceof ManagedBlob) {
                BlobTextFromDocument blobTextFromDoc = this.getBlobText(doc);
                blobTextFromDoc.addBlob((String)propName, (ManagedBlob)blob);
                items.add(blobTextFromDoc);
            }
        });
        this.textProperties.forEach(propName -> {
            String text = PropertyUtils.getPropertyValue(doc, propName, String.class);
            if (text != null) {
                BlobTextFromDocument blobTextFromDoc = this.getBlobText(doc);
                blobTextFromDoc.addProperty((String)propName, text);
                items.add(blobTextFromDoc);
            }
        });
        if (items.isEmpty() && !this.customProperties.isEmpty()) {
            items.add(this.getBlobText(doc));
        }
        return items;
    }

    protected BlobTextFromDocument getBlobText(DocumentModel doc) {
        BlobTextFromDocument blobTextFromDoc = new BlobTextFromDocument(doc.getId(), doc.getRepositoryName(), doc.getParentRef().toString(), doc.getType(), doc.getFacets());
        this.customProperties.forEach(propName -> {
            String propVal = PropertyUtils.getPropertyValue(doc, propName, String.class);
            if (propVal != null) {
                blobTextFromDoc.addProperty((String)propName, propVal);
            }
        });
        return blobTextFromDoc;
    }
}

