/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.pipes.filters;

import java.util.List;
import java.util.Map;
import org.nuxeo.ai.pipes.filters.Filter;
import org.nuxeo.ai.pipes.streams.Initializable;
import org.nuxeo.ecm.core.api.DocumentModel;

public class FacetFilter
implements Filter.DocumentFilter,
Initializable {
    protected List<String> includedFacets;
    protected List<String> excludedFacets;

    @Override
    public void init(Map<String, String> options) {
        this.includedFacets = this.propsList(options.get("includedFacets"));
        this.excludedFacets = this.propsList(options.getOrDefault("excludedFacets", "Folderish"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean test(DocumentModel doc) {
        if (!this.excludedFacets.stream().noneMatch(arg_0 -> ((DocumentModel)doc).hasFacet(arg_0))) return false;
        if (this.includedFacets.isEmpty()) return true;
        if (!this.includedFacets.stream().anyMatch(arg_0 -> ((DocumentModel)doc).hasFacet(arg_0))) return false;
        return true;
    }
}

