/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.pipes.functions;

import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ai.pipes.services.JacksonUtil;
import org.nuxeo.ai.pipes.services.PipelineService;
import org.nuxeo.ai.pipes.types.BlobTextFromDocument;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.kv.KeyValueStore;

public class BinaryTextListener
implements EventListener {
    public static final String BINARY_TEXT_STREAM_KV = "BINARY_TEXT_STREAM";
    private static final Log log = LogFactory.getLog(BinaryTextListener.class);
    protected final String binaryProperty;
    protected final String inputProperty;
    protected final String consumerName;
    protected final int timeout;
    protected final boolean useWindow;

    public BinaryTextListener(String consumerName, String binaryProperty, String inputProperty, int windowSizeSeconds) {
        this.binaryProperty = StringUtils.isNotBlank((CharSequence)binaryProperty) ? binaryProperty : "fulltextBinary";
        this.inputProperty = StringUtils.isNotBlank((CharSequence)inputProperty) ? inputProperty : "file:content";
        this.consumerName = consumerName;
        this.timeout = windowSizeSeconds;
        boolean bl = this.useWindow = this.timeout > 0;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Creating a BinaryTextListener for %s property and a %s source property.  Sending to a '%s' stream, window size is %s (in seconds)", binaryProperty, inputProperty, consumerName, windowSizeSeconds));
        }
    }

    public void handleEvent(Event event) {
        String text;
        DocumentModel doc = JacksonUtil.toDoc(event);
        Boolean hasText = (Boolean)event.getContext().getProperty(this.binaryProperty);
        if (doc != null && hasText != null && hasText.booleanValue() && StringUtils.isNotBlank((CharSequence)(text = (String)((Object)event.getContext().getProperty("systemPropertyValue"))))) {
            if (this.useWindow) {
                KeyValueStore kvStore = ((KeyValueService)Framework.getService(KeyValueService.class)).getKeyValueStore(BINARY_TEXT_STREAM_KV);
                byte[] existing = kvStore.get(doc.getId());
                if (existing == null) {
                    if (this.handledBinaryText(doc, text)) {
                        kvStore.put(doc.getId(), "", (long)this.timeout);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Skipping because there is already an event for %s and %s", doc.getId(), text.substring(0, text.length() < 25 ? text.length() : 25)));
                }
            } else {
                this.handledBinaryText(doc, text);
            }
        }
    }

    protected boolean handledBinaryText(DocumentModel doc, String text) {
        Consumer<Record> consumer = ((PipelineService)Framework.getService(PipelineService.class)).getConsumer(this.consumerName);
        if (consumer != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Handling new binary text for doc " + doc.getId()));
            }
            BlobTextFromDocument blobTextFromDoc = new BlobTextFromDocument(doc);
            blobTextFromDoc.addProperty(this.inputProperty, text);
            consumer.accept(JacksonUtil.toRecord(blobTextFromDoc.getKey(), blobTextFromDoc));
            return true;
        }
        return false;
    }
}

