/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.pipes.functions;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.nuxeo.ai.pipes.events.DocEventToStream;
import org.nuxeo.ai.pipes.functions.PreFilterFunction;
import org.nuxeo.ai.pipes.services.JacksonUtil;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.lib.stream.computation.Record;

public class PropertiesToStream
extends PreFilterFunction<Event, Collection<Record>> {
    protected List<String> blobProperties;
    protected List<String> textProperties;
    protected List<String> customProperties;

    @Override
    public void init(Map<String, String> options) {
        this.processOptions(options);
        this.transformation = this.setupTransformation();
    }

    protected void processOptions(Map<String, String> options) {
        this.blobProperties = this.propsList(options.get("blobProperties"));
        this.textProperties = this.propsList(options.get("textProperties"));
        this.customProperties = this.propsList(options.get("customProperties"));
    }

    protected Function<Event, Collection<Record>> setupTransformation() {
        DocEventToStream func = new DocEventToStream(this.blobProperties, this.textProperties, this.customProperties);
        return func.andThen(items -> items.stream().map(i -> JacksonUtil.toRecord(i.getKey(), i)).collect(Collectors.toList()));
    }
}

