/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.pipes.filters;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.nuxeo.ai.pipes.filters.Filter;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class DocumentEventFilter
implements Filter.EventFilter {
    protected final Predicate<Event> eventPredicate;
    protected final Predicate<DocumentModel> docPredicate;

    protected DocumentEventFilter(Predicate<Event> eventPredicate, Predicate<DocumentModel> docPredicate) {
        this.eventPredicate = eventPredicate;
        this.docPredicate = docPredicate;
    }

    @Override
    public boolean test(Event event) {
        if (this.eventPredicate.test(event)) {
            DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
            if (docCtx == null) {
                return false;
            }
            DocumentModel doc = docCtx.getSourceDocument();
            return doc != null && this.test(doc);
        }
        return false;
    }

    @Override
    public boolean test(DocumentModel documentModel) {
        return this.docPredicate.test(documentModel);
    }

    public static class Builder {
        protected List<Predicate<DocumentModel>> documentFilters = new ArrayList<Predicate<DocumentModel>>();
        protected List<Predicate<Event>> eventFilters = new ArrayList<Predicate<Event>>();

        public Builder withDocumentFilter(Filter.DocumentFilter filter) {
            this.documentFilters.add(filter);
            return this;
        }

        public Builder withEventFilter(Filter.EventFilter filter) {
            this.eventFilters.add(filter);
            return this;
        }

        public Filter.EventFilter build() {
            Predicate<Event> eventFilter = this.eventFilters.stream().reduce(Objects::nonNull, Predicate::and);
            Predicate<DocumentModel> docFilter = this.documentFilters.stream().reduce(Objects::nonNull, Predicate::and);
            return new DocumentEventFilter(eventFilter, docFilter);
        }
    }
}

