/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.pipes.functions;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ai.pipes.streams.Initializable;
import org.nuxeo.ecm.core.api.NuxeoException;

public class PreFilterFunction<T, R>
implements Function<T, R>,
Initializable {
    private static final Log log = LogFactory.getLog(PreFilterFunction.class);
    protected Predicate<? super T> filter;
    protected Function<? super T, ? extends R> transformation;

    public PreFilterFunction() {
    }

    protected PreFilterFunction(Predicate<? super T> filter, Function<? super T, ? extends R> transformation) {
        this.filter = filter;
        this.transformation = transformation;
    }

    @Override
    public void init(Map<String, String> options) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initializing function " + this.getClass().getSimpleName()));
        }
    }

    public void setFilter(Predicate<? super T> filter) {
        this.filter = filter;
    }

    @Override
    public R apply(T in) {
        try {
            if (this.filter == null || this.filter.test(in)) {
                return this.transformation.apply(in);
            }
        }
        catch (ClassCastException | NullPointerException cce) {
            log.error((Object)"Invalid function definition ", (Throwable)cce);
        }
        catch (NuxeoException ne) {
            log.error((Object)"Nuxeo error from function ", (Throwable)ne);
        }
        return null;
    }
}

