/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.pipes.functions;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class Predicates {
    private Predicates() {
    }

    public static Predicate<Event> event() {
        return Objects::nonNull;
    }

    public static Predicate<DocumentModel> doc() {
        return Objects::nonNull;
    }

    public static Predicate<Event> docEvent(Predicate<DocumentModel> predicate) {
        return Predicates.docEvent(Predicates.event(), predicate);
    }

    public static Predicate<Event> docEvent(Predicate<Event> eventPredicate, Predicate<DocumentModel> predicate) {
        Objects.requireNonNull(eventPredicate);
        Objects.requireNonNull(predicate);
        return eventPredicate.and(e -> {
            DocumentEventContext docCtx = (DocumentEventContext)e.getContext();
            if (docCtx == null) {
                return false;
            }
            DocumentModel doc = docCtx.getSourceDocument();
            return doc != null && predicate.test(doc);
        });
    }

    public static Predicate<DocumentModel> isNotProxy() {
        return Predicates.doc().and(d -> !d.isProxy());
    }

    public static Predicate<DocumentModel> hasFacets(String ... facets) {
        return Predicates.doc().and(d -> Arrays.stream(facets).allMatch(arg_0 -> ((DocumentModel)d).hasFacet(arg_0)));
    }

    public static Predicate<DocumentModel> isPicture() {
        return Predicates.isNotProxy().and(d -> d.hasFacet("Picture"));
    }
}

