/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ai.pipes.functions;

import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeConstants;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.runtime.api.Framework;

public class PropertyUtils {
    public static final String FILE_CONTENT = "file:content";
    public static final String NAME_PROP = "name";
    public static final String TYPE_PROP = "type";
    public static final String IMAGE_TYPE = "img";
    public static final String TEXT_TYPE = "txt";
    private static final Log log = LogFactory.getLog(PropertyUtils.class);

    private PropertyUtils() {
    }

    public static <T> T getPropertyValue(DocumentModel doc, String propertyName, Class<T> type) {
        Serializable propVal = PropertyUtils.getPropertyValue(doc, propertyName);
        if (propVal != null) {
            if (type.isAssignableFrom(propVal.getClass())) {
                return (T)propVal;
            }
            if (propVal instanceof Blob && type.isAssignableFrom(String.class)) {
                return (T)PropertyUtils.base64EncodeBlob((Blob)propVal);
            }
            if (propVal instanceof Calendar && type.isAssignableFrom(String.class)) {
                return (T)((Calendar)propVal).toInstant().toString();
            }
            if (propVal.getClass().isArray() && propVal.getClass().getComponentType().isAssignableFrom(String.class)) {
                throw new UnsupportedOperationException("Multi-value properties are currently not supported.");
            }
            if (type.isAssignableFrom(String.class)) {
                return (T)propVal.toString();
            }
            throw new UnsupportedOperationException("Converting complex properties is currently not supported.");
        }
        return null;
    }

    public static String base64EncodeBlob(Blob blob) {
        try {
            if (blob != null) {
                return Base64.encodeBase64String((byte[])blob.getByteArray());
            }
        }
        catch (IOException ioe) {
            log.warn((Object)"Failed to convert a blob to a String", (Throwable)ioe);
        }
        return null;
    }

    public static Serializable getPropertyValue(DocumentModel doc, String propertyName) {
        try {
            return doc.getProperty(propertyName).getValue();
        }
        catch (PropertyNotFoundException e) {
            QName qName = QName.valueOf((String)propertyName);
            if ("ecm".equals(qName.getPrefix())) {
                switch (qName.getLocalName()) {
                    case "uuid": {
                        return doc.getId();
                    }
                    case "name": {
                        return doc.getName();
                    }
                    case "title": {
                        return doc.getTitle();
                    }
                    case "path": {
                        return doc.getPathAsString();
                    }
                    case "repository": {
                        return doc.getRepositoryName();
                    }
                    case "primaryType": {
                        return doc.getType();
                    }
                    case "mixinType": {
                        return String.join((CharSequence)",", doc.getFacets());
                    }
                    case "parentId": {
                        DocumentRef parentRef = doc.getParentRef();
                        return parentRef != null ? parentRef.toString() : null;
                    }
                    case "currentLifeCycleState": {
                        return doc.getCurrentLifeCycleState();
                    }
                    case "versionLabel": {
                        return doc.getVersionLabel();
                    }
                    case "versionVersionableId": {
                        return doc.getVersionSeriesId();
                    }
                    case "pos": {
                        return doc.getPos();
                    }
                    case "isProxy": {
                        return Boolean.valueOf(doc.isProxy());
                    }
                    case "isTrashed": {
                        return Boolean.valueOf(doc.isTrashed());
                    }
                    case "isVersion": {
                        return Boolean.valueOf(doc.isVersion());
                    }
                    case "isCheckedIn": {
                        return Boolean.valueOf(!doc.isCheckedOut());
                    }
                    case "isLatestVersion": {
                        return Boolean.valueOf(doc.isLatestVersion());
                    }
                    case "isLatestMajorVersion": {
                        return Boolean.valueOf(doc.isLatestMajorVersion());
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Unknown property %s so I am ignoring it.", propertyName));
            }
            return null;
        }
    }

    public static Map<String, String> getPropertyWithType(String prop) {
        Field field = ((SchemaManager)Framework.getService(SchemaManager.class)).getField(prop);
        if (field == null) {
            throw new PropertyNotFoundException(prop + " does not exist.");
        }
        HashMap<String, String> feature = new HashMap<String, String>();
        feature.put(NAME_PROP, prop);
        feature.put(TYPE_PROP, TypeConstants.isContentType((Type)field.getType()) ? IMAGE_TYPE : TEXT_TYPE);
        return feature;
    }

    public static List<Map<String, String>> propsToTypedList(Collection<String> properties) {
        return properties.stream().map(PropertyUtils::getPropertyWithType).collect(Collectors.toList());
    }

    public static boolean notNull(DocumentModel doc, String propertyName) {
        return PropertyUtils.getPropertyValue(doc, propertyName) != null;
    }
}

