/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.binary.metadata.internals;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.nuxeo.binary.metadata.api.BinaryMetadataException;
import org.nuxeo.binary.metadata.api.BinaryMetadataProcessor;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandAvailability;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.runtime.api.Framework;

public class ExifToolProcessor
implements BinaryMetadataProcessor {
    private static final Log log = LogFactory.getLog(ExifToolProcessor.class);
    private static final String META_NON_USED_SOURCE_FILE = "SourceFile";
    protected final ObjectMapper jacksonMapper = new ObjectMapper();
    protected final CommandLineExecutorService commandLineService = (CommandLineExecutorService)Framework.getLocalService(CommandLineExecutorService.class);

    @Override
    public boolean writeMetadata(Blob blob, Map<String, Object> metadata) {
        CommandAvailability ca = this.commandLineService.getCommandAvailability("exiftool-read-taglist");
        if (!ca.isAvailable()) {
            throw new BinaryMetadataException("Command 'exiftool-write' is not available.");
        }
        if (blob == null) {
            throw new BinaryMetadataException("The following command " + ca + " cannot be executed with a null blob");
        }
        try {
            ExecResult er;
            try (CloseableFile source = blob.getCloseableFile();){
                CmdParameters params = new CmdParameters();
                params.addNamedParameter("inFilePath", source.getFile(), true);
                params.addNamedParameter("tagList", this.getCommandTags(metadata), false);
                er = this.commandLineService.execCommand("exiftool-write", params);
            }
            boolean success = er.isSuccessful();
            if (!success) {
                log.error((Object)("There was an error executing the following command: " + er.getCommandLine() + ". \n" + (String)er.getOutput().get(0)));
            }
            return success;
        }
        catch (CommandNotAvailable commandNotAvailable) {
            throw new BinaryMetadataException("Command 'exiftool-write' is not available.", commandNotAvailable);
        }
        catch (IOException ioException) {
            throw new BinaryMetadataException(ioException);
        }
    }

    @Override
    public Map<String, Object> readMetadata(Blob blob, List<String> metadata) {
        CommandAvailability ca = this.commandLineService.getCommandAvailability("exiftool-read-taglist");
        if (!ca.isAvailable()) {
            throw new BinaryMetadataException("Command 'exiftool-read-taglist' is not available.");
        }
        if (blob == null) {
            throw new BinaryMetadataException("The following command " + ca + " cannot be executed with a null blob");
        }
        try {
            ExecResult er;
            try (CloseableFile source = blob.getCloseableFile();){
                CmdParameters params = new CmdParameters();
                params.addNamedParameter("inFilePath", source.getFile(), true);
                params.addNamedParameter("tagList", this.getCommandTags(metadata), false);
                er = this.commandLineService.execCommand("exiftool-read-taglist", params);
            }
            return this.returnResultMap(er);
        }
        catch (CommandNotAvailable commandNotAvailable) {
            throw new RuntimeException("Command 'exiftool-read-taglist' is not available.", commandNotAvailable);
        }
        catch (IOException ioException) {
            throw new BinaryMetadataException(ioException);
        }
    }

    @Override
    public Map<String, Object> readMetadata(Blob blob) {
        CommandAvailability ca = this.commandLineService.getCommandAvailability("exiftool-read");
        if (!ca.isAvailable()) {
            throw new BinaryMetadataException("Command 'exiftool-read' is not available.");
        }
        if (blob == null) {
            throw new BinaryMetadataException("The following command " + ca + " cannot be executed with a null blob");
        }
        try {
            ExecResult er;
            try (CloseableFile source = blob.getCloseableFile();){
                CmdParameters params = new CmdParameters();
                params.addNamedParameter("inFilePath", source.getFile(), true);
                er = this.commandLineService.execCommand("exiftool-read", params);
            }
            return this.returnResultMap(er);
        }
        catch (CommandNotAvailable commandNotAvailable) {
            throw new RuntimeException("Command 'exiftool-read' is not available.", commandNotAvailable);
        }
        catch (IOException ioException) {
            throw new BinaryMetadataException(ioException);
        }
    }

    protected Map<String, Object> returnResultMap(ExecResult er) throws IOException {
        if (!er.isSuccessful()) {
            throw new BinaryMetadataException("There was an error executing the following command: " + er.getCommandLine(), (Throwable)er.getError());
        }
        StringBuilder sb = new StringBuilder();
        for (String line : er.getOutput()) {
            sb.append(line);
        }
        String jsonOutput = sb.toString();
        List resultList = (List)this.jacksonMapper.readValue(jsonOutput, (TypeReference)new TypeReference<List<HashMap<String, Object>>>(){});
        Map resultMap = (Map)resultList.get(0);
        resultMap.remove(META_NON_USED_SOURCE_FILE);
        return resultMap;
    }

    protected String getCommandTags(List<String> metadataList) {
        StringBuilder sb = new StringBuilder();
        for (String metadata : metadataList) {
            sb.append("-" + metadata + " ");
        }
        return sb.toString();
    }

    protected String getCommandTags(Map<String, Object> metadataMap) {
        StringBuilder sb = new StringBuilder();
        for (String metadata : metadataMap.keySet()) {
            Object metadataValue = metadataMap.get(metadata);
            if (metadataValue == null) {
                metadataValue = "";
            }
            metadataValue = metadataValue.toString().replace(" ", "\\ ");
            sb.append("-" + metadata + "=" + metadataValue + " ");
        }
        return sb.toString();
    }
}

