/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.binary.metadata.internals.operations;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.binary.metadata.api.BinaryMetadataException;
import org.nuxeo.binary.metadata.api.BinaryMetadataService;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;

@Operation(id="Blob.SetMetadataFromDocument", category="Files", label="Write Metadata To Binary From Document", description="Write metadata to a Blob (xpath parameter, or BlobHolder if empty) from a document (input) given a custom metadata mapping defined in a Properties parameter, using a named processor (exifTool for instance).", since="7.1", addToStudio=true, aliases={"Binary.WriteMetadataFromDocument"})
public class WriteMetadataToBinaryFromDocument {
    public static final String ID = "Blob.SetMetadataFromDocument";
    @Context
    protected BinaryMetadataService binaryMetadataService;
    @Param(name="processor", required=false, description="The processor to execute for overriding the input document blob.")
    protected String processor = "exifTool";
    @Param(name="metadata", required=true, description="Metadata to write into the input document blob.")
    protected Properties metadata;
    @Param(name="blobXPath", required=false, description="The blob xpath on the document. Default blob property for empty parameter.")
    protected String blobXPath;

    @OperationMethod
    public void run(DocumentModel doc) {
        Blob blob;
        HashMap<String, Object> metadataMap = new HashMap<String, Object>(this.metadata.size());
        for (Map.Entry entry : this.metadata.entrySet()) {
            metadataMap.put((String)entry.getKey(), entry.getValue());
        }
        if (this.blobXPath != null) {
            blob = (Blob)doc.getProperty(this.blobXPath).getValue(Blob.class);
        } else {
            BlobHolder blobHolder = (BlobHolder)doc.getAdapter(BlobHolder.class);
            blob = blobHolder.getBlob();
        }
        if (blob == null) {
            String message = this.blobXPath != null ? "No blob attached for document '" + doc.getId() + "'. Please specify a blobXPath parameter." : "No blob attached for document '" + doc.getId() + "' and blob xpath '" + this.blobXPath + "'. Please specify another blobXPath parameter.";
            throw new BinaryMetadataException(message);
        }
        this.binaryMetadataService.writeMetadata(this.processor, blob, metadataMap);
    }
}

