/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.box.api.collaboration;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.RandomStringUtils;
import org.nuxeo.box.api.adapter.BoxAdapter;
import org.nuxeo.box.api.folder.adapter.BoxFolderAdapter;
import org.nuxeo.box.api.marshalling.dao.BoxCollaboration;
import org.nuxeo.box.api.marshalling.dao.BoxUser;
import org.nuxeo.box.api.marshalling.exceptions.BoxJSONException;
import org.nuxeo.box.api.marshalling.exceptions.BoxRestException;
import org.nuxeo.box.api.service.BoxService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.AbstractResource;
import org.nuxeo.ecm.webengine.model.impl.ResourceTypeImpl;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="collaborations")
@Produces(value={"application/json"})
public class BoxCollaborationObject
extends AbstractResource<ResourceTypeImpl> {
    BoxService boxService;
    BoxFolderAdapter boxFolder;

    public void initialize(Object ... args) {
        this.boxService = (BoxService)Framework.getLocalService(BoxService.class);
        if (args != null && args.length == 1) {
            try {
                String folderId = (String)args[0];
                CoreSession session = this.ctx.getCoreSession();
                DocumentModel folder = session.getDocument((DocumentRef)new IdRef(folderId));
                this.boxFolder = (BoxFolderAdapter)folder.getAdapter(BoxAdapter.class);
            }
            catch (Exception e) {
                throw WebException.wrap((Throwable)e);
            }
            this.setRoot(true);
        }
    }

    @GET
    public String doGetCollaborations() throws NoSuchDocumentException, ClientException, BoxJSONException {
        return this.boxService.toJSONString(this.boxFolder.getCollaborations());
    }

    @GET
    @Path(value="/{collaborationId}")
    public String doGetCollaboration(@PathParam(value="collaborationId") String collaborationId) throws NoSuchDocumentException, ClientException, BoxJSONException {
        CoreSession session = this.ctx.getCoreSession();
        String[] collaborationIds = this.boxService.getCollaborationArrayIds(collaborationId);
        DocumentModel folder = session.getDocument((DocumentRef)new IdRef(collaborationIds[0]));
        this.boxFolder = (BoxFolderAdapter)folder.getAdapter(BoxAdapter.class);
        BoxCollaboration collaboration = this.boxFolder.getCollaboration(collaborationIds[1]);
        if (collaboration == null) {
            throw new BoxRestException("There is no collaboration with id " + collaborationId, Response.Status.NOT_FOUND.getStatusCode());
        }
        return this.boxService.toJSONString(collaboration);
    }

    @DELETE
    @Path(value="/{collaborationId}")
    public void doRemoveCollaboration(@PathParam(value="collaborationId") String collaborationId) throws NoSuchDocumentException, ClientException, BoxJSONException {
        CoreSession session = this.ctx.getCoreSession();
        String[] collaborationIds = this.boxService.getCollaborationArrayIds(collaborationId);
        IdRef docRef = new IdRef(collaborationIds[0]);
        ACP acp = session.getACP((DocumentRef)docRef);
        acp.removeACL(collaborationIds[1]);
        session.setACP((DocumentRef)docRef, acp, true);
        session.save();
    }

    @POST
    public String doPostCollaboration(String jsonBoxCollaboration) throws ClientException, BoxJSONException {
        String collaborationId;
        BoxCollaboration boxCollaboration;
        String documentId;
        DocumentModel targetDocument;
        CoreSession session = this.ctx.getCoreSession();
        ACP acp = session.getACP((targetDocument = session.getDocument((DocumentRef)new IdRef(documentId = (boxCollaboration = this.boxService.getBoxCollaboration(jsonBoxCollaboration)).getFolder().getId()))).getRef());
        ACL acl = acp.getACL(collaborationId = RandomStringUtils.random((int)6, (boolean)false, (boolean)true));
        if (acl == null) {
            acl = new ACLImpl(collaborationId);
            acp.addACL(acl);
        }
        ACE ace = new ACE(boxCollaboration.getAccessibleBy().getId(), (String)this.boxService.getNxBoxRole().inverse().get((Object)boxCollaboration.getRole()), true);
        acl.add((Object)ace);
        session.setACP(targetDocument.getRef(), acp, true);
        session.save();
        BoxFolderAdapter boxFolderUpdated = (BoxFolderAdapter)targetDocument.getAdapter(BoxAdapter.class);
        return this.boxService.toJSONString(this.boxService.getBoxCollaboration(boxFolderUpdated, ace, collaborationId));
    }

    @PUT
    @Path(value="/{collaborationId}")
    public String doPutCollaboration(@PathParam(value="collaborationId") String collaborationId, String jsonBoxCollaboration) throws ClientException, BoxJSONException {
        CoreSession session = this.ctx.getCoreSession();
        BoxCollaboration boxCollaboration = this.boxService.getBoxCollaboration(jsonBoxCollaboration);
        String[] collaborationIds = this.boxService.getCollaborationArrayIds(collaborationId);
        IdRef docRef = new IdRef(collaborationIds[0]);
        DocumentModel targetDocument = session.getDocument((DocumentRef)docRef);
        ACP acp = session.getACP(targetDocument.getRef());
        ACL acl = acp.getACL(collaborationIds[1]);
        if (acl == null) {
            return null;
        }
        ACE existingACE = acl.getACEs()[0];
        String updatedPermission = (String)this.boxService.getNxBoxRole().inverse().get((Object)boxCollaboration.getRole());
        BoxUser updatedUser = boxCollaboration.getAccessibleBy();
        String user = updatedUser != null ? updatedUser.getId() : existingACE.getUsername();
        String permission = updatedPermission != null ? updatedPermission : existingACE.getPermission();
        acl.remove(0);
        ACE ace = new ACE(user, permission, true);
        acl.add((Object)ace);
        session.setACP(targetDocument.getRef(), acp, true);
        session.save();
        BoxFolderAdapter boxFolderUpdated = (BoxFolderAdapter)targetDocument.getAdapter(BoxAdapter.class);
        return this.boxService.toJSONString(this.boxService.getBoxCollaboration(boxFolderUpdated, ace, collaborationIds[1]));
    }
}

