/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.box.api.folder.adapter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.nuxeo.box.api.adapter.BoxAdapter;
import org.nuxeo.box.api.marshalling.dao.BoxCollaboration;
import org.nuxeo.box.api.marshalling.dao.BoxCollection;
import org.nuxeo.box.api.marshalling.dao.BoxEmail;
import org.nuxeo.box.api.marshalling.dao.BoxFolder;
import org.nuxeo.box.api.marshalling.dao.BoxItem;
import org.nuxeo.box.api.service.BoxService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.runtime.api.Framework;

public class BoxFolderAdapter
extends BoxAdapter {
    public BoxFolderAdapter(DocumentModel doc) throws ClientException {
        super(doc);
        CoreSession session = doc.getCoreSession();
        HashMap<String, Object> boxEmailProperties = new HashMap<String, Object>();
        boxEmailProperties.put("access", null);
        boxEmailProperties.put("email", null);
        BoxEmail boxEmail = new BoxEmail(Collections.unmodifiableMap(boxEmailProperties));
        this.boxProperties.put("folder_upload_email", boxEmail);
        this.boxProperties.put("item_collection", this.getItemCollection(session, "100", "0", "*"));
        this.boxItem = new BoxFolder(Collections.unmodifiableMap(this.boxProperties));
    }

    @Override
    public BoxItem getMiniItem() {
        HashMap<String, Object> boxProperties = new HashMap<String, Object>();
        boxProperties.put("id", this.boxItem.getId());
        boxProperties.put("sequence_id", this.boxItem.getSequenceId());
        boxProperties.put("name", this.boxItem.getName());
        return new BoxFolder(boxProperties);
    }

    public BoxCollection getItemCollection(CoreSession session, String limit, String offset, String fields) throws ClientException {
        HashMap<String, Object> collectionProperties = new HashMap<String, Object>();
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM Document WHERE ecm:parentId=");
        query.append("'" + this.doc.getId() + "'");
        DocumentModelList children = session.query(query.toString(), null, Long.parseLong(limit), Long.parseLong(offset), false);
        collectionProperties.put("entries", this.boxService.getBoxDocumentCollection(children, fields));
        collectionProperties.put("total_count", children.size());
        return new BoxCollection(Collections.unmodifiableMap(collectionProperties));
    }

    public BoxCollection getCollaborations() throws ClientException {
        BoxService boxService = (BoxService)Framework.getLocalService(BoxService.class);
        ArrayList<BoxCollaboration> boxCollaborations = new ArrayList<BoxCollaboration>();
        HashMap<String, Serializable> collectionProperties = new HashMap<String, Serializable>();
        CoreSession session = this.doc.getCoreSession();
        for (ACL acl : session.getACP((DocumentRef)new IdRef(this.doc.getId())).getACLs()) {
            if ("local".equals(acl.getName()) || "inherited".equals(acl.getName())) continue;
            for (ACE ace : acl.getACEs()) {
                if (!ace.isGranted()) continue;
                boxCollaborations.add(boxService.getBoxCollaboration(this, ace, acl.getName()));
            }
        }
        collectionProperties.put("entries", boxCollaborations);
        collectionProperties.put("total_count", Integer.valueOf(boxCollaborations.size()));
        return new BoxCollection(Collections.unmodifiableMap(collectionProperties));
    }

    public BoxCollaboration getCollaboration(String collaborationId) throws ClientException {
        CoreSession session = this.doc.getCoreSession();
        ACL acl = session.getACP((DocumentRef)new IdRef(this.doc.getId())).getACL(collaborationId);
        if (acl == null) {
            return null;
        }
        return this.boxService.getBoxCollaboration(this, acl.getACEs()[0], collaborationId);
    }
}

