/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.box.api.comment.adapter;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.nuxeo.box.api.marshalling.dao.BoxComment;
import org.nuxeo.box.api.marshalling.dao.BoxFile;
import org.nuxeo.box.api.marshalling.dao.BoxTypedObject;
import org.nuxeo.box.api.marshalling.dao.BoxUser;
import org.nuxeo.box.api.marshalling.exceptions.BoxJSONException;
import org.nuxeo.box.api.marshalling.exceptions.BoxRestException;
import org.nuxeo.box.api.service.BoxService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class BoxCommentAdapter {
    protected BoxComment boxComment;
    protected final Map<String, Object> boxProperties = new HashMap<String, Object>();
    protected DocumentModel comment;

    public BoxCommentAdapter(DocumentModel doc) throws ClientException {
        BoxService boxService = (BoxService)Framework.getLocalService(BoxService.class);
        this.comment = doc;
        this.boxProperties.put("id", doc.getId());
        this.boxProperties.put("created_at", ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime((Object)doc.getPropertyValue("comment:creationDate"))));
        this.boxProperties.put("modified_at", ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime((Object)doc.getPropertyValue("dc:modified"))));
        UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
        NuxeoPrincipal creator = userManager.getPrincipal((String)((Object)doc.getPropertyValue("comment:author")));
        BoxUser boxCreator = boxService.fillUser(creator);
        this.boxProperties.put("created_by", boxCreator);
        this.boxProperties.put("message", doc.getPropertyValue("comment:text"));
        this.boxProperties.put("is_reply_comment", null);
        this.boxProperties.put("item", this.fillItem(doc));
        this.boxComment = new BoxComment(this.boxProperties);
    }

    public void setBoxComment(BoxComment boxComment) {
        for (String field : boxComment.getKeySet()) {
            this.boxComment.put(field, boxComment.getValue(field));
        }
    }

    private BoxTypedObject fillItem(DocumentModel doc) throws ClientException {
        CommentManager commentManager = (CommentManager)Framework.getLocalService(CommentManager.class);
        List targetList = commentManager.getDocumentsForComment(doc);
        if (targetList.isEmpty()) {
            throw new BoxRestException("Cannot find any document for the comment with id " + doc.getId());
        }
        DocumentModel target = (DocumentModel)targetList.get(0);
        HashMap<String, Object> itemProperties = new HashMap<String, Object>();
        itemProperties.put("id", target.getId());
        BoxFile boxItem = new BoxFile(itemProperties);
        return boxItem;
    }

    public void save(CoreSession session) throws ClientException, ParseException, InvocationTargetException, IllegalAccessException, BoxJSONException {
        this.comment.setPropertyValue("comment:text", (Serializable)((Object)this.boxComment.getMessage()));
        session.saveDocument(this.comment);
        session.save();
    }

    public BoxComment getBoxComment() {
        return this.boxComment;
    }
}

