/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.box.api.folder.item;

import com.google.common.base.Objects;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.nuxeo.box.api.adapter.BoxAdapter;
import org.nuxeo.box.api.folder.adapter.BoxFolderAdapter;
import org.nuxeo.box.api.marshalling.dao.BoxCollection;
import org.nuxeo.box.api.marshalling.exceptions.BoxJSONException;
import org.nuxeo.box.api.service.BoxService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.AbstractResource;
import org.nuxeo.ecm.webengine.model.impl.ResourceTypeImpl;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="item")
@Produces(value={"application/json"})
public class BoxItemObject
extends AbstractResource<ResourceTypeImpl> {
    BoxFolderAdapter folderAdapter;
    BoxService boxService;

    public void initialize(Object ... args) {
        this.boxService = (BoxService)Framework.getLocalService(BoxService.class);
        try {
            String folderId = (String)args[0];
            CoreSession session = this.ctx.getCoreSession();
            DocumentModel folder = session.getDocument((DocumentRef)new IdRef(folderId));
            this.folderAdapter = (BoxFolderAdapter)folder.getAdapter(BoxAdapter.class);
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
        this.setRoot(true);
    }

    @GET
    public String doGetItems(@QueryParam(value="offset") String offset, @QueryParam(value="limit") String limit, @QueryParam(value="fields") String fields) throws BoxJSONException, ClientException {
        CoreSession session = this.ctx.getCoreSession();
        BoxCollection itemCollection = this.folderAdapter.getItemCollection(session, (String)Objects.firstNonNull((Object)limit, (Object)"100"), (String)Objects.firstNonNull((Object)offset, (Object)"0"), (String)Objects.firstNonNull((Object)fields, (Object)"*"));
        return this.boxService.toJSONString(itemCollection);
    }
}

