/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.box.api.marshalling.jsonparsing;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.nuxeo.box.api.marshalling.dao.BoxObject;
import org.nuxeo.box.api.marshalling.interfaces.IBoxResourceHub;
import org.nuxeo.box.api.marshalling.interfaces.IBoxType;

public abstract class BaseBoxResourceHub
implements IBoxResourceHub {
    private static final Map<String, IBoxType> lowercaseStringToType = new HashMap<String, IBoxType>();

    public BaseBoxResourceHub() {
        this.initializeTypes();
    }

    @Override
    public Class getClass(IBoxType type) {
        return BoxObject.class;
    }

    protected Map<String, IBoxType> getLowerCaseStringToTypeMap() {
        return lowercaseStringToType;
    }

    protected abstract Class getConcreteClassForIBoxType();

    protected abstract Class getObjectClassGivenConcreteIBoxType(IBoxType var1);

    protected void initializeTypes() {
    }

    protected void initializeEnumTypes(Class<? extends Enum> cls) {
        Enum[] types;
        Map<String, IBoxType> map = this.getLowerCaseStringToTypeMap();
        for (Enum type : types = cls.getEnumConstants()) {
            String str = type.name().toLowerCase(Locale.ENGLISH);
            map.put(str, (IBoxType)((Object)type));
        }
    }
}

