/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.maven.plugin.logging.Log;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DemuxInputStream;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.listener.BigProjectLogger;
import org.apache.tools.ant.taskdefs.Typedef;
import org.codehaus.plexus.util.IOUtil;

public class AntClient {
    private static final ThreadLocal<Project> instance = new ThreadLocal();
    public static final String MAVEN_CLIENT_REF = "maven.client.ref";
    protected ClassLoader loader;
    protected Project project;
    protected boolean allowInput = false;
    private static final FileCleaningTracker FILE_CLEANING_TRACKER = new FileCleaningTracker();

    public boolean isAllowInput() {
        return this.allowInput;
    }

    public void setAllowInput(boolean allowInput) {
        this.allowInput = allowInput;
    }

    public AntClient(Log logger) {
        this(null, logger);
    }

    public AntClient(ClassLoader loader, Log mavenLog) {
        if (loader == null && (loader = Thread.currentThread().getContextClassLoader()) == null) {
            loader = AntClient.class.getClassLoader();
        }
        this.loader = loader;
        this.project = new Project();
        this.project.setCoreLoader(loader);
        this.project.setKeepGoingMode(false);
        this.project.addBuildListener((BuildListener)this.createLogger(mavenLog));
        this.project.init();
        this.initTasks();
        instance.set(this.project);
    }

    public static Project getInstance() {
        return instance.get();
    }

    protected void initTasks() {
        this.project.log("Initialize Ant Tasks", 4);
        Typedef typedef = new Typedef();
        typedef.setProject(this.project);
        typedef.setResource("org/nuxeo/build/antlib.xml");
        typedef.setURI("urn:nuxeo-build");
        typedef.execute();
        typedef = new Typedef();
        typedef.setProject(this.project);
        typedef.setResource("org/nuxeo/build/artifact/antlib.xml");
        typedef.setURI("urn:nuxeo-artifact");
        typedef.execute();
    }

    public Project getProject() {
        return this.project;
    }

    public void run(File buildFile) throws BuildException {
        this.run(buildFile, (List<String>)null);
    }

    public void run(URL buildFile) throws BuildException {
        this.run(this.saveURL(buildFile), null);
    }

    public void run(URL buildFile, List<String> targets) throws BuildException {
        this.run(this.saveURL(buildFile), targets);
    }

    public void run(File buildFile, List<String> targets) throws BuildException {
        PrintStream previousErr = System.err;
        PrintStream previousOut = System.out;
        InputStream in = System.in;
        DemuxInputStream newIn = null;
        PrintStream newOut = null;
        PrintStream newErr = null;
        try {
            DefaultInputHandler handler = new DefaultInputHandler();
            this.project.setInputHandler((InputHandler)handler);
            if (this.allowInput) {
                this.project.setDefaultInputStream(System.in);
            }
            newIn = new DemuxInputStream(this.project);
            System.setIn((InputStream)newIn);
            newOut = new PrintStream((OutputStream)new DemuxOutputStream(this.project, false));
            System.setOut(newOut);
            newErr = new PrintStream((OutputStream)new DemuxOutputStream(this.project, true));
            System.setErr(newErr);
            if (!buildFile.isAbsolute()) {
                buildFile = new File(this.project.getBaseDir(), buildFile.getPath());
            }
            this.project.setUserProperty("ant.file", buildFile.getPath());
            ProjectHelper.configureProject((Project)this.project, (File)buildFile);
            this.project.fireBuildStarted();
            if (targets != null) {
                this.project.getExecutor().executeTargets(this.project, targets.toArray(new String[targets.size()]));
            } else {
                this.project.getExecutor().executeTargets(this.project, new String[]{this.project.getDefaultTarget()});
            }
            this.project.fireBuildFinished(null);
        }
        catch (BuildException e) {
            try {
                this.project.fireBuildFinished((Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                System.setOut(previousOut);
                System.setErr(previousErr);
                System.setIn(in);
                IOUtil.close(newIn);
                IOUtil.close(newOut);
                IOUtil.close(newErr);
                throw throwable;
            }
        }
        System.setOut(previousOut);
        System.setErr(previousErr);
        System.setIn(in);
        IOUtil.close((InputStream)newIn);
        IOUtil.close((OutputStream)newOut);
        IOUtil.close((OutputStream)newErr);
    }

    protected BuildLogger createLogger(Log mavenLog) {
        BigProjectLogger logger = new BigProjectLogger(){

            protected void printMessage(String message, PrintStream stream, int priority) {
                String prefix;
                if (priority > this.msgOutputLevel) {
                    return;
                }
                switch (priority) {
                    case 0: {
                        prefix = "[ERROR] ";
                        break;
                    }
                    case 1: {
                        prefix = "[WARNING] ";
                        break;
                    }
                    case 2: {
                        prefix = "[INFO] ";
                        break;
                    }
                    case 3: {
                        prefix = "[VERBOSE] ";
                        break;
                    }
                    default: {
                        prefix = "[DEBUG] ";
                    }
                }
                super.printMessage(prefix + message, stream, priority);
            }
        };
        logger.setOutputPrintStream(System.out);
        logger.setErrorPrintStream(System.err);
        if (mavenLog == null) {
            logger.setMessageOutputLevel(2);
        } else if (mavenLog.isDebugEnabled()) {
            logger.setMessageOutputLevel(4);
        } else if (mavenLog.isInfoEnabled()) {
            logger.setMessageOutputLevel(2);
        } else if (mavenLog.isWarnEnabled()) {
            logger.setMessageOutputLevel(1);
        } else if (mavenLog.isErrorEnabled()) {
            logger.setMessageOutputLevel(0);
        } else {
            logger.setMessageOutputLevel(4);
        }
        return logger;
    }

    private File saveURL(URL url) {
        File file;
        InputStream in = null;
        FileOutputStream out = null;
        try {
            File file2 = File.createTempFile("ant_client_url_", ".tmp");
            FILE_CLEANING_TRACKER.track(file2, (Object)this);
            in = url.openStream();
            out = new FileOutputStream(file2);
            IOUtil.copy((InputStream)in, (OutputStream)out);
            file = file2;
        }
        catch (IOException e) {
            try {
                throw new BuildException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(in);
                IOUtil.close(out);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)in);
        IOUtil.close((OutputStream)out);
        return file;
    }
}

