/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.tools.ant.BuildException;
import org.eclipse.aether.graph.DependencyNode;
import org.nuxeo.build.ant.artifact.ExpandTask;
import org.nuxeo.build.maven.filter.Filter;

public class NuxeoExpandTask
extends ExpandTask {
    private Map<String, Boolean> includedScopes = new HashMap<String, Boolean>();
    private boolean includeCompileScope = true;
    private boolean includeProvidedScope = false;
    private boolean includeRuntimeScope = true;
    private boolean includeTestScope = false;
    private boolean includeSystemScope = true;
    private String[] groupPrefixes = new String[]{"org.nuxeo"};

    public void setGroupPrefixes(String groupPrefixes) {
        ArrayList<String> prefixes = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(groupPrefixes, ",");
        while (st.hasMoreTokens()) {
            prefixes.add(st.nextToken());
        }
        this.groupPrefixes = prefixes.toArray(new String[0]);
    }

    public NuxeoExpandTask() {
        this.setDepth("all");
    }

    @Override
    public void execute() throws BuildException {
        this.getIncludedScopes().put("compile", this.includeCompileScope);
        this.getIncludedScopes().put("provided", this.includeProvidedScope);
        this.getIncludedScopes().put("runtime", this.includeRuntimeScope);
        this.getIncludedScopes().put("test", this.includeTestScope);
        this.getIncludedScopes().put("system", this.includeSystemScope);
        this.filter.addFilter(new Filter(){

            @Override
            public boolean accept(Artifact artifact) {
                return true;
            }

            public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                if (node.getDependency().isOptional()) {
                    return false;
                }
                if ("".equals(node.getDependency().getScope())) {
                    NuxeoExpandTask.this.log("Node with no scope accepted (root node?): " + node, 4);
                    return true;
                }
                return NuxeoExpandTask.this.getIncludedScopes().get(node.getDependency().getScope());
            }
        });
        super.execute();
    }

    @Override
    protected boolean acceptNode(DependencyNode node) {
        for (String prefix : this.groupPrefixes) {
            if (!node.getArtifact().getGroupId().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    protected Map<String, Boolean> getIncludedScopes() {
        return this.includedScopes;
    }

    public void setIncludeCompileScope(boolean includeCompileScope) {
        this.includeCompileScope = includeCompileScope;
    }

    public void setIncludeProvidedScope(boolean includeProvidedScope) {
        this.includeProvidedScope = includeProvidedScope;
    }

    public void setIncludeRuntimeScope(boolean includeRuntimeScope) {
        this.includeRuntimeScope = includeRuntimeScope;
    }

    public void setIncludeTestScope(boolean includeTestScope) {
        this.includeTestScope = includeTestScope;
    }

    public void setIncludeSystemScope(boolean includeSystemScope) {
        this.includeSystemScope = includeSystemScope;
    }
}

