/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;
import org.apache.maven.RepositoryUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.util.StringUtils;
import org.nuxeo.build.maven.AntBuildMojo;
import org.nuxeo.build.maven.ArtifactDescriptor;
import org.nuxeo.build.maven.graph.DependencyUtils;

public class PrintDependencyManagementTask
extends Task {
    private String output;
    private FORMAT format = FORMAT.KV_F_GAV;
    private boolean append = false;
    private String key;
    private List<String> scopes = null;
    private String checkOutput;
    private boolean check;

    public void execute() throws BuildException {
        AntBuildMojo mojo = AntBuildMojo.getInstance();
        OutputStream out = System.out;
        OutputStream err = System.err;
        try {
            Artifact artifact;
            if (this.output != null) {
                out = new FileOutputStream(this.output, this.append);
            }
            if (this.checkOutput != null) {
                err = new FileOutputStream(this.checkOutput, this.append);
            }
            if (this.key == null) {
                artifact = RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)mojo.getProject().getArtifact());
            } else {
                ArtifactDescriptor ad = new ArtifactDescriptor(this.key);
                artifact = ad.getAetherArtifact();
            }
            if (StringUtils.isEmpty((String)artifact.getVersion())) {
                artifact = DependencyUtils.setManagedVersion(artifact);
            }
            if (StringUtils.isEmpty((String)artifact.getVersion())) {
                artifact = DependencyUtils.setNewestVersion(artifact);
            }
            ArtifactDescriptorRequest request = new ArtifactDescriptorRequest();
            request.setArtifact(artifact);
            request.setRepositories(mojo.getRemoteRepositories());
            ArtifactDescriptorResult result = mojo.getSystem().readArtifactDescriptor((RepositorySystemSession)mojo.getSession(), request);
            Throwable checks = new Throwable();
            for (Dependency dependency : result.getManagedDependencies()) {
                String scope;
                if (this.check) {
                    try {
                        DependencyUtils.resolve(dependency.getArtifact());
                    }
                    catch (ArtifactResolutionException e) {
                        checks.addSuppressed(e);
                        String msg = "";
                        if (this.checkOutput == null) {
                            msg = "Cannot resolve ";
                        }
                        err.write((msg + this.toString(dependency)).getBytes(AntBuildMojo.getInstance().getEncoding()));
                        continue;
                    }
                }
                if ("".equals(scope = dependency.getScope())) {
                    scope = "compile";
                }
                if (this.scopes != null && !this.scopes.contains(scope)) continue;
                out.write(this.toString(dependency).getBytes(AntBuildMojo.getInstance().getEncoding()));
            }
            for (Throwable t : checks.getSuppressed()) {
                this.log(t.getMessage(), 1);
            }
        }
        catch (IOException | ArtifactDescriptorException e) {
            throw new BuildException(e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
            IOUtils.closeQuietly((OutputStream)err);
        }
    }

    public String toString(Dependency dependency) {
        Artifact artifact = dependency.getArtifact();
        StringBuilder sb = new StringBuilder();
        switch (this.format) {
            case KV_F_GAV: {
                String filename;
                if (artifact.getFile() == null) {
                    filename = artifact.getArtifactId() + "-" + artifact.getBaseVersion();
                    if (!StringUtils.isEmpty((String)artifact.getClassifier())) {
                        filename = filename + "-" + artifact.getClassifier();
                    }
                    filename = filename + "." + artifact.getExtension();
                } else {
                    filename = artifact.getFile().getName();
                }
                sb.append(filename);
                sb.append('=');
            }
            case GAV: {
                sb.append(artifact.getGroupId());
                sb.append(':').append(artifact.getArtifactId());
                sb.append(':').append(artifact.getVersion());
                sb.append(':').append(artifact.getExtension());
                sb.append(':').append(artifact.getClassifier());
                sb.append(':').append(dependency.getScope());
                break;
            }
        }
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setFormat(FORMAT format) {
        this.format = format;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setScopes(String scopes) {
        StringTokenizer st = new StringTokenizer(scopes, ",");
        this.scopes = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            this.scopes.add(st.nextToken());
        }
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setCheck(boolean check) {
        this.check = check;
    }

    public void setCheckOutput(String checkOutput) {
        this.checkOutput = checkOutput;
    }

    public static enum FORMAT {
        GAV,
        KV_F_GAV;

    }
}

