/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyResult;
import org.nuxeo.build.ant.AntClient;
import org.nuxeo.build.ant.artifact.ArtifactFile;
import org.nuxeo.build.ant.artifact.ArtifactSetParser;
import org.nuxeo.build.ant.artifact.Excludes;
import org.nuxeo.build.ant.artifact.Expand;
import org.nuxeo.build.ant.artifact.Includes;
import org.nuxeo.build.ant.artifact.ResolveFile;
import org.nuxeo.build.maven.AntBuildMojo;
import org.nuxeo.build.maven.filter.AncestorFilter;
import org.nuxeo.build.maven.filter.AndFilter;
import org.nuxeo.build.maven.filter.ArtifactIdFilter;
import org.nuxeo.build.maven.filter.ClassifierFilter;
import org.nuxeo.build.maven.filter.CompositeFilter;
import org.nuxeo.build.maven.filter.DependencyNodeFilter;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.filter.GroupIdFilter;
import org.nuxeo.build.maven.filter.IsOptionalFilter;
import org.nuxeo.build.maven.filter.NotFilter;
import org.nuxeo.build.maven.filter.ScopeFilter;
import org.nuxeo.build.maven.filter.TypeFilter;
import org.nuxeo.build.maven.filter.VersionFilter;
import org.nuxeo.build.maven.graph.DependencyUtils;
import org.nuxeo.build.maven.graph.Graph;
import org.nuxeo.build.maven.graph.Node;

public class ArtifactSet
extends DataType
implements ResourceCollection {
    public AndFilter filter = new AndFilter();
    public String id;
    public File src;
    public Expand expand;
    public List<ArtifactFile> artifactFiles;
    public List<ArtifactSet> artifactSets;
    public Includes includes;
    public Excludes excludes;
    protected Collection<Artifact> artifacts;
    private Collection<Node> roots = new HashSet<Node>();
    public List<ResolveFile> resolveFiles;

    public void setGroupId(String groupId) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.filter.addFilter(new GroupIdFilter(groupId));
    }

    public void setArtifactId(String artifactId) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.filter.addFilter(new ArtifactIdFilter(artifactId));
    }

    public void setVersion(String version) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.filter.addFilter(new VersionFilter(version));
    }

    public void setClassifier(String classifier) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.filter.addFilter(new ClassifierFilter(classifier));
    }

    public void setType(String type) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.filter.addFilter(new TypeFilter(type));
    }

    public void setScope(String scope) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (StringUtils.isBlank((CharSequence)scope)) {
            this.filter.addFilter(new NotFilter(new ScopeFilter("test")));
            this.filter.addFilter(new NotFilter(new ScopeFilter("provided")));
        } else if (!"*".equals(scope)) {
            this.filter.addFilter(new ScopeFilter(scope));
        }
    }

    public void setOptional(boolean isOptional) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.filter.addFilter(new IsOptionalFilter(isOptional));
    }

    public void setPattern(String pattern) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.filter.addFiltersFromPattern(pattern);
    }

    public void setAncestor(String ancestor) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.filter.addFilter(new AncestorFilter(ancestor));
    }

    public void setId(String id) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.id = id;
    }

    public void setSrc(File importFile) {
        this.src = importFile;
    }

    public void setExcludeRoots(boolean excludeRoots) {
        if (excludeRoots) {
            this.filter.addFilter(new DependencyNodeFilter(this.roots));
        }
    }

    public void addExpand(Expand expand) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.expand = expand;
    }

    public void addFile(ArtifactFile artifact) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.artifactFiles == null) {
            this.artifactFiles = new ArrayList<ArtifactFile>();
        }
        this.artifactFiles.add(artifact);
    }

    public void addResolveFile(ResolveFile artifact) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.resolveFiles == null) {
            this.resolveFiles = new ArrayList<ResolveFile>();
        }
        this.resolveFiles.add(artifact);
    }

    public void addArtifactSet(ArtifactSet set) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.artifactSets == null) {
            this.artifactSets = new ArrayList<ArtifactSet>();
        }
        this.artifactSets.add(set);
    }

    public void addIncludes(Includes includes) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.includes != null) {
            throw new BuildException("Found an Includes that is defined more than once in an artifactSet");
        }
        this.includes = includes;
    }

    public void addExcludes(Excludes excludes) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.excludes != null) {
            throw new BuildException("Found an Excludes that is defined more than once in an artifactSet");
        }
        this.excludes = excludes;
    }

    public void setRefid(Reference ref) {
        super.setRefid(ref);
    }

    protected ArtifactSet getRef(Project p) {
        return (ArtifactSet)((Object)this.getCheckedRef(p));
    }

    protected Filter buildFilter() {
        AndFilter f = new AndFilter();
        if (!this.filter.isEmpty()) {
            f.addFilters(this.filter.getFilters());
        }
        if (this.includes != null) {
            f.addFilter(this.includes.getFilter());
        }
        if (this.excludes != null) {
            f.addFilter(this.excludes.getFilter());
        }
        return f.isEmpty() ? Filter.ANY : CompositeFilter.compact(f);
    }

    protected Collection<Artifact> computeNodes() {
        int n;
        AntClient.getInstance().log("Computing nodes...", 4);
        ArrayList<Artifact> resultArtifacts = new ArrayList<Artifact>();
        this.collectImportedNodes(this.roots);
        if (this.artifactFiles != null) {
            for (ArtifactFile artifactFile : this.artifactFiles) {
                this.roots.add(artifactFile.getNode());
            }
        }
        if (this.resolveFiles != null) {
            Graph graph = new Graph();
            for (ResolveFile file : this.resolveFiles) {
                this.roots.add(graph.addRootNode(file.getArtifactDescriptor().getDependency()));
            }
        }
        if (this.artifactSets != null) {
            for (ArtifactSet artifactSet : this.artifactSets) {
                resultArtifacts.addAll(artifactSet.getArtifacts());
            }
        }
        Filter finalFilter = this.buildFilter();
        int n2 = Integer.MAX_VALUE;
        if (this.expand != null) {
            this.expand.filter.addFilter(finalFilter);
            finalFilter = CompositeFilter.compact(this.expand.filter);
            n = this.expand.depth;
        }
        this.roots.addAll(AntBuildMojo.getInstance().getGraph().getRoots());
        for (Node node : this.roots) {
            DependencyResult result = DependencyUtils.resolveDependencies(node, finalFilter, n);
            for (ArtifactResult artifactResult : result.getArtifactResults()) {
                resultArtifacts.add(artifactResult.getArtifact());
            }
            if (finalFilter.accept(result.getRoot(), null)) continue;
            Artifact root = result.getRoot().getArtifact();
            resultArtifacts.remove(root);
        }
        return resultArtifacts;
    }

    public Collection<Artifact> getArtifacts() {
        if (this.isReference()) {
            return this.getRef(this.getProject()).getArtifacts();
        }
        if (this.artifacts == null) {
            this.artifacts = this.computeNodes();
        }
        if (AntBuildMojo.getInstance().getLog().isDebugEnabled()) {
            AntClient.getInstance().log("ArtifactSet.getArtifacts() " + this.artifacts, (Throwable)new Error(), 4);
        }
        if (this.id != null) {
            Collection<Artifact> copy = this.artifacts;
            this.artifacts = null;
            return copy;
        }
        return this.artifacts;
    }

    public Iterator<Resource> iterator() {
        return ArtifactSet.createIterator(this.getArtifacts());
    }

    public static Iterator<Resource> createIterator(Collection<Artifact> collection) {
        ArrayList<FileResource> files = new ArrayList<FileResource>();
        for (Artifact artifact : collection) {
            File file = artifact.getFile();
            if (file == null) continue;
            FileResource fr = new FileResource(file);
            fr.setBaseDir(file.getParentFile());
            files.add(fr);
        }
        return files.iterator();
    }

    public int size() {
        return this.getArtifacts().size();
    }

    public boolean isFilesystemOnly() {
        return true;
    }

    public void collectImportedNodes(Collection<Node> nodesCollection) {
        if (this.src == null) {
            return;
        }
        try {
            ArtifactSetParser parser = new ArtifactSetParser(this.getProject());
            parser.parse(this.src, nodesCollection);
        }
        catch (IOException e) {
            throw new BuildException("Failed to import artifacts file: " + this.src, (Throwable)e);
        }
    }
}

