/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.util.Collection;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.aether.graph.DependencyNode;
import org.nuxeo.build.ant.artifact.Excludes;
import org.nuxeo.build.ant.artifact.Expand;
import org.nuxeo.build.ant.artifact.Includes;
import org.nuxeo.build.maven.AntBuildMojo;
import org.nuxeo.build.maven.filter.AndFilter;
import org.nuxeo.build.maven.filter.CompositeFilter;
import org.nuxeo.build.maven.graph.Graph;
import org.nuxeo.build.maven.graph.Node;

public class ExpandTask
extends Task {
    public String key;
    public int depth = Integer.MAX_VALUE;
    public AndFilter filter = new AndFilter();

    public void setKey(String key) {
        this.key = key;
    }

    public void setDepth(String depth) {
        this.depth = Expand.readExpand(depth);
    }

    public void addExcludes(Excludes excludes) {
        this.filter.addFilter(excludes.getFilter());
    }

    public void addIncludes(Includes includes) {
        this.filter.addFilter(includes.getFilter());
    }

    protected boolean acceptNode(DependencyNode node) {
        return true;
    }

    public void execute() throws BuildException {
        Graph graph;
        AntBuildMojo mojo = AntBuildMojo.getInstance();
        if (this.key != null) {
            graph = new Graph();
            Collection<Node> nodes = mojo.getGraph().find(this.key);
            this.addRootNodes(graph, nodes);
        } else {
            graph = mojo.newGraph();
        }
        graph.resolveDependencies(CompositeFilter.compact(this.filter), this.depth);
    }

    public void addRootNodes(Graph graph, Collection<? extends DependencyNode> nodes) {
        for (DependencyNode dependencyNode : nodes) {
            if ("pom".equals(dependencyNode.getArtifact().getExtension())) {
                for (DependencyNode child : dependencyNode.getChildren()) {
                    if (!this.acceptNode(dependencyNode)) continue;
                    graph.addRootNode(new Node(graph, child));
                }
                continue;
            }
            if (!this.acceptNode(dependencyNode)) continue;
            graph.addRootNode(new Node(graph, dependencyNode));
        }
    }
}

