/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.util.graph.visitor.CloningDependencyVisitor;
import org.nuxeo.build.maven.AntBuildMojo;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.graph.FlatPrinterDependencyVisitor;
import org.nuxeo.build.maven.graph.Graph;
import org.nuxeo.build.maven.graph.Node;
import org.nuxeo.build.maven.graph.TreePrinterDependencyVisitor;

public class PrintGraphTask
extends Task {
    private String output;
    private String mode = "tree";
    public static final int FORMAT_GAV = 0;
    public static final int FORMAT_KV_F_GAV = 1;
    private int format = 0;
    private boolean append = false;
    private String source;
    private List<String> scopes = null;
    public static final String MODE_SDK = "sdk";
    public static final String MODE_FLAT = "flat";
    public static final String MODE_TREE = "tree";

    public void execute() throws BuildException {
        List<Object> roots;
        if (this.scopes == null) {
            this.scopes = MODE_TREE.equals(this.mode) ? Arrays.asList("compile", "provided", "runtime", "system", "test") : Arrays.asList("compile", "runtime", "system");
        }
        if (this.source != null) {
            roots = new ArrayList();
            Graph graph = new Graph();
            roots.add(graph.addRootNode(this.source));
            graph.resolveDependencies(Filter.ANY, 0);
        } else {
            roots = AntBuildMojo.getInstance().getGraph().getRoots();
        }
        OutputStream out = System.out;
        try {
            if (this.output != null) {
                out = new FileOutputStream(this.output, this.append);
            }
            if (MODE_TREE.equals(this.mode)) {
                TreePrinterDependencyVisitor pdv = new TreePrinterDependencyVisitor(out, this.format, this.scopes, roots);
                for (Node node : roots) {
                    this.log("Visiting " + node, 4);
                    CloningDependencyVisitor cdv = new CloningDependencyVisitor();
                    node.accept((DependencyVisitor)cdv);
                    cdv.getRootNode().accept((DependencyVisitor)pdv);
                }
            } else {
                FlatPrinterDependencyVisitor pdv = new FlatPrinterDependencyVisitor(out, this.format, this.scopes);
                pdv.addIgnores(roots);
                for (Node node : roots) {
                    this.log("Visiting " + node, 4);
                    node.accept(pdv);
                }
                pdv.print();
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setMode(String mode) {
        if (MODE_SDK.equals(mode)) {
            this.format = 1;
        }
        this.mode = mode;
    }

    public void setFormat(int format) {
        this.format = format;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setScopes(String scopes) {
        StringTokenizer st = new StringTokenizer(scopes, ",");
        this.scopes = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            this.scopes.add(st.nextToken());
        }
    }
}

