/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.nuxeo.build.maven.graph.DependencyUtils;

public class ArtifactDescriptor {
    public static final Pattern PATTERN = Pattern.compile("(?<groupId>[^: ]+):(?<artifactId>[^: ]+)(?::(?<version>[^: ]*)(?::(?<type>[^: ]*)(?::(?<classifier>[^: ]*)(?::(?<scope>[^: ]*))?)?)?)?");
    protected String groupId = null;
    protected String artifactId = null;
    protected String version = null;
    protected String type = null;
    protected String classifier = null;
    protected String scope = null;

    public ArtifactDescriptor() {
    }

    public ArtifactDescriptor(String groupId, String artifactId, String version, String type, String classifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.classifier = classifier;
        this.scope = "compile";
    }

    public ArtifactDescriptor(String key) {
        Matcher m = PATTERN.matcher(key);
        if (!m.matches()) {
            throw new IllegalArgumentException(String.format("Invalid key '%s', expected format is '%s'", key, "<groupId>:<artifactId>[:<version>[:<type>[:<classifier>[:<scope>]]]]"));
        }
        this.groupId = m.group("groupId");
        this.artifactId = m.group("artifactId");
        if (m.group("version") != null && !m.group("version").isEmpty()) {
            this.version = m.group("version");
        }
        this.type = m.group("type") != null && !m.group("type").isEmpty() ? m.group("type") : "jar";
        if (m.group("classifier") != null && !m.group("classifier").isEmpty()) {
            this.classifier = m.group("classifier");
        }
        this.scope = m.group("scope") != null && !m.group("scope").isEmpty() ? m.group("scope") : "compile";
    }

    public String getNodeKeyPattern() {
        if (this.groupId != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.groupId);
            if (this.artifactId != null) {
                buf.append(':').append(this.artifactId);
                if (this.version != null) {
                    buf.append(':').append(this.version);
                    if (this.type != null) {
                        buf.append(':').append(this.type);
                    }
                }
            }
            return buf.toString();
        }
        return null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.groupId).append(':').append(this.artifactId);
        buf.append(':').append(this.version);
        buf.append(':').append(this.type);
        buf.append(':');
        if (this.classifier != null) {
            buf.append(this.classifier);
        }
        buf.append(':').append(this.scope);
        return buf.toString();
    }

    public org.apache.maven.artifact.Artifact getMavenArtifact() {
        Artifact aetherArtifact = this.getAetherArtifact();
        return DependencyUtils.aetherToMaven(aetherArtifact, this.scope);
    }

    public Artifact getAetherArtifact() {
        return this.getDependency().getArtifact();
    }

    public Dependency getDependency() {
        return new Dependency((Artifact)new DefaultArtifact(this.groupId, this.artifactId, this.classifier, this.type, this.version), this.scope);
    }

    public static ArtifactDescriptor parseQuietly(String key) {
        try {
            return new ArtifactDescriptor(key);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            return new ArtifactDescriptor();
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean isEmpty() {
        return this.groupId == null && this.artifactId == null && this.groupId == null && this.scope == null && this.type == null && this.classifier == null;
    }
}

