/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.PatternSet;

public class ZipDiffTask
extends Task {
    public static String newline = System.getProperty("line.separator");
    protected File file1;
    protected File file2;
    protected File includesfile;
    protected File excludesfile;
    private FileWriter fileWriter;
    private PatternSet patternSet;
    private boolean ignoreContent = false;
    private String ignoreContentPattern = ".*(?<!SNAPSHOT)\\.jar$";

    public void setFile1(File file1) {
        this.file1 = file1;
    }

    public void setFile2(File file2) {
        this.file2 = file2;
    }

    public void setIncludesfile(File includesfile) {
        this.includesfile = includesfile;
    }

    public void setExcludesfile(File excludesfile) {
        this.excludesfile = excludesfile;
    }

    public void setPatternsetid(String id) {
        this.patternSet = new PatternSet();
        this.getProject().addReference(id, (Object)this.patternSet);
    }

    public void setIgnoreContent(boolean ignoreContent) {
        this.ignoreContent = ignoreContent;
    }

    public void setIgnoreContentPattern(String ignoreContentPattern) {
        this.ignoreContentPattern = ignoreContentPattern;
    }

    public void execute() throws BuildException {
        ZipFile zipfile1 = null;
        ZipFile zipfile2 = null;
        try {
            zipfile1 = new ZipFile(this.file1);
            zipfile2 = new ZipFile(this.file2);
            LinkedHashSet<String> set1 = new LinkedHashSet<String>();
            Enumeration<? extends ZipEntry> zipEntries = zipfile1.entries();
            while (zipEntries.hasMoreElements()) {
                set1.add(zipEntries.nextElement().getName());
            }
            LinkedHashSet<String> set2 = new LinkedHashSet<String>();
            Enumeration<? extends ZipEntry> zipEntries2 = zipfile2.entries();
            while (zipEntries2.hasMoreElements()) {
                set2.add(zipEntries2.nextElement().getName());
            }
            try {
                if (this.includesfile != null) {
                    this.includesfile.createNewFile();
                    this.fileWriter = new FileWriter(this.includesfile);
                }
                for (String filename : set1) {
                    if (!set2.contains(filename)) {
                        this.log("Only in " + this.file1.getName() + ": " + filename, 2);
                        this.include(filename, this.fileWriter);
                        continue;
                    }
                    set2.remove(filename);
                    if (this.ignoreContent || filename.matches(this.ignoreContentPattern)) continue;
                    try {
                        if (IOUtils.contentEquals((InputStream)zipfile1.getInputStream(zipfile1.getEntry(filename)), (InputStream)zipfile2.getInputStream(zipfile2.getEntry(filename)))) continue;
                        this.log("Content differs: " + filename, 2);
                        this.include(filename, this.fileWriter);
                    }
                    catch (IOException e) {
                        this.log(e, 1);
                    }
                }
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((Writer)this.fileWriter);
            }
            try {
                if (this.excludesfile != null) {
                    this.excludesfile.createNewFile();
                    this.fileWriter = new FileWriter(this.excludesfile);
                }
                for (String filename : set2) {
                    this.log("Only in " + this.file2.getName() + ": " + filename, 2);
                    this.exclude(filename, this.fileWriter);
                }
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((Writer)this.fileWriter);
            }
        }
        catch (IOException e) {
            throw new BuildException("Error opening " + this.file1 + " or " + this.file2, (Throwable)e);
        }
        finally {
            if (zipfile1 != null) {
                try {
                    zipfile1.close();
                }
                catch (IOException e) {
                    throw new BuildException((Throwable)e);
                }
            }
            if (zipfile2 != null) {
                try {
                    zipfile2.close();
                }
                catch (IOException e) {
                    throw new BuildException((Throwable)e);
                }
            }
        }
    }

    protected void exclude(String filename, FileWriter writer) throws IOException {
        if (this.patternSet != null) {
            PatternSet.NameEntry exclude = this.patternSet.createExclude();
            exclude.setName(filename);
        }
        this.write(filename, writer);
    }

    protected void include(String filename, FileWriter writer) throws IOException {
        if (this.patternSet != null) {
            PatternSet.NameEntry include = this.patternSet.createInclude();
            include.setName(filename);
        }
        this.write(filename, writer);
    }

    private void write(String filename, FileWriter writer) throws IOException {
        if (writer != null) {
            writer.write(filename + newline);
        }
    }
}

