/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.nuxeo.build.maven.AntBuildMojo;

public class AttachArtifactTask
extends Task {
    private File file;
    private String classifier;
    private String type;

    public void setFile(File file) {
        this.file = file;
    }

    public void setClassifier(String classifier) {
        this.classifier = "".equals(classifier) ? null : classifier;
    }

    @Deprecated
    public void setTarget(String artifactKey) {
        this.log("The target parameter is deprecated and ignored. The attach task now only applies to the current project.", 1);
    }

    public void setType(String type) {
        this.type = type;
    }

    public void execute() throws BuildException {
        MavenProject pom = AntBuildMojo.getInstance().getProject();
        this.log("Attaching " + this.file + " to " + pom, 2);
        if (this.type == null) {
            this.type = this.getExtension(this.file.getName());
            this.log("Unspecified type, using: " + this.type, 1);
        }
        Artifact pomArtifact = pom.getArtifact();
        if (this.classifier != null || !this.type.equals(pomArtifact.getType())) {
            AntBuildMojo.getInstance().getProjectHelper().attachArtifact(pom, this.type, this.classifier, this.file);
        } else {
            pomArtifact.setFile(this.file);
            pomArtifact.setResolved(true);
        }
    }

    private String getExtension(String name) {
        int idx = name.lastIndexOf(46);
        return name.substring(idx + 1);
    }
}

