/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.resources.FileResource;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.nuxeo.build.maven.ArtifactDescriptor;
import org.nuxeo.build.maven.graph.DependencyUtils;

public class ResolveFile
extends FileResource {
    protected String key;
    protected String classifier;
    private File file = null;

    public void setKey(String pattern) {
        int p = pattern.lastIndexOf(59);
        if (p > -1) {
            this.key = pattern.substring(0, p);
            this.classifier = pattern.substring(p + 1);
        } else {
            this.key = pattern;
        }
    }

    @Deprecated
    public void setClassifier(String classifier) {
        this.log("The classifier parameter is deprecated, put it in the key.", 1);
        this.classifier = classifier;
    }

    protected File resolveFile() {
        ArtifactDescriptor ad = new ArtifactDescriptor(this.key);
        if (ad.classifier != null) {
            this.classifier = ad.classifier;
        } else if (this.classifier != null) {
            ad.classifier = this.classifier;
        }
        try {
            if (this.file != null) {
                return this.file;
            }
            Artifact artifact = ad.getAetherArtifact();
            if (artifact.getFile() != null) {
                this.file = artifact.getFile();
                return this.file;
            }
            if ("".equals(artifact.getVersion())) {
                artifact = DependencyUtils.setManagedVersion(artifact);
            }
            if ("".equals(artifact.getVersion())) {
                artifact = DependencyUtils.setNewestVersion(artifact);
            }
            artifact = DependencyUtils.resolve(artifact);
            this.file = artifact.getFile();
            return this.file;
        }
        catch (ArtifactResolutionException e) {
            throw new BuildException(String.format("Cannot resolve file with key '%s'", ad), (Throwable)e);
        }
    }

    public File getFile() {
        if (this.isReference()) {
            return ((FileResource)this.getCheckedRef()).getFile();
        }
        return this.resolveFile();
    }

    public File getBaseDir() {
        return this.isReference() ? ((FileResource)this.getCheckedRef()).getBaseDir() : this.getFile().getParentFile();
    }
}

