/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.nuxeo.build.maven.ArtifactDescriptor;
import org.nuxeo.build.maven.graph.DependencyUtils;

public class ResolveFiles
extends DataType
implements ResourceCollection {
    private Properties source;
    private String classifier;
    private List<Resource> artifacts;

    public void setSource(String source) throws FileNotFoundException, IOException {
        File[] files;
        this.source = new Properties();
        File sourceFile = new File(source);
        for (File file : files = sourceFile.getParentFile().listFiles((FileFilter)new WildcardFileFilter(sourceFile.getName()))) {
            this.log("Loading " + file, 4);
            this.source.load(new FileInputStream(file));
        }
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public boolean isFilesystemOnly() {
        return true;
    }

    public Iterator<Resource> iterator() {
        if (this.isReference()) {
            return ((ResourceCollection)this.getCheckedRef()).iterator();
        }
        if (this.artifacts == null) {
            this.artifacts = new ArrayList<Resource>();
            for (String string : this.source.values()) {
                try {
                    this.artifacts.add((Resource)this.resolveFile(string));
                }
                catch (ArtifactResolutionException e) {
                    this.log(e.getMessage(), 1);
                }
            }
        }
        return this.artifacts.iterator();
    }

    private FileResource resolveFile(String artifactKey) throws ArtifactResolutionException {
        File file;
        Artifact artifact;
        ArtifactDescriptor ad = new ArtifactDescriptor(artifactKey);
        if (this.classifier != null) {
            ad.classifier = this.classifier;
        }
        if ((artifact = ad.getAetherArtifact()).getFile() != null) {
            file = artifact.getFile();
        } else {
            if ("".equals(artifact.getVersion())) {
                artifact = DependencyUtils.setManagedVersion(artifact);
            }
            if ("".equals(artifact.getVersion())) {
                artifact = DependencyUtils.setNewestVersion(artifact);
            }
            artifact = DependencyUtils.resolve(artifact);
            file = artifact.getFile();
        }
        FileResource fr = new FileResource(file);
        fr.setBaseDir(file.getParentFile());
        return fr;
    }

    public int size() {
        return this.artifacts.size();
    }
}

