/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.profile;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Sequential;
import org.nuxeo.build.ant.profile.AntProfileManager;
import org.nuxeo.build.maven.AntBuildMojo;

public class ProfileTask
extends Sequential {
    public String name;
    public String activate;
    public String group;
    public String defaultProfile;

    public void setName(String name) {
        if (this.activate != null) {
            throw new BuildException("Name and activate properties are exclusive. You cannot specify both.");
        }
        if (this.group != null) {
            throw new BuildException("group and name properties are exclusive. You cannot specify both.");
        }
        if (this.defaultProfile != null) {
            throw new BuildException("Default and name properties are exclusive. You cannot specify both.");
        }
        this.name = name;
    }

    public void setActivate(String activate) {
        if (this.name != null) {
            throw new BuildException("Name and activate properties are exclusive. You cannot specify both.");
        }
        if (this.group != null) {
            throw new BuildException("group and activate properties are exclusive. You cannot specify both.");
        }
        if (this.defaultProfile != null) {
            throw new BuildException("Default and activate properties are exclusive. You cannot specify both.");
        }
        this.activate = activate;
    }

    public void setGroup(String group) {
        if (this.name != null) {
            throw new BuildException("Group and name properties are exclusive. You cannot specify both.");
        }
        if (this.activate != null) {
            throw new BuildException("Group and activate properties are exclusive. You cannot specify both.");
        }
        this.group = group;
    }

    public void setDefault(String defaultProfile) {
        if (this.name != null) {
            throw new BuildException("default and name properties are exclusive. You cannot specify both.");
        }
        if (this.activate != null) {
            throw new BuildException("default and activate properties are exclusive. You cannot specify both.");
        }
        this.defaultProfile = defaultProfile;
    }

    public void addTask(Task nestedTask) {
        if (this.activate != null) {
            throw new BuildException("Cannot use nested elements when specifying activate attribute.");
        }
        super.addTask(nestedTask);
    }

    public void execute() throws BuildException {
        AntProfileManager mgr = AntBuildMojo.getInstance().getAntProfileManager();
        if (mgr.isProfileActive(this.name)) {
            super.execute();
        } else if (this.group != null) {
            String[] profiles = this.group.split("\\s*,\\s*");
            AntBuildMojo.getInstance().getAntProfileManager().addGroup(profiles, this.activate);
        } else if (this.activate != null) {
            mgr.activateProfiles(this.activate);
        }
    }
}

