/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven;

import java.io.File;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.settings.Settings;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.nuxeo.build.ant.AntClient;
import org.nuxeo.build.ant.artifact.Expand;
import org.nuxeo.build.ant.profile.AntProfileManager;
import org.nuxeo.build.maven.filter.TrueFilter;
import org.nuxeo.build.maven.graph.Graph;
import org.nuxeo.build.maven.graph.ScopeDependencySelector;

@Mojo(name="build", threadSafe=true, defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyCollection=ResolutionScope.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class AntBuildMojo
extends AbstractMojo {
    private static final ThreadLocal<AntBuildMojo> instance = new ThreadLocal();
    protected Graph graph;
    protected AntProfileManager antProfileManager;
    @Parameter
    protected File buildFile;
    @Parameter
    protected File[] buildFiles;
    @Parameter
    protected String target;
    @Parameter
    protected String[] targets;
    @Parameter(defaultValue="0")
    protected String expand;
    @Component
    protected RepositorySystem system;
    @Parameter(property="repositorySystemSession", readonly=true)
    protected RepositorySystemSession repositorySystemSession;
    protected DefaultRepositorySystemSession session;
    @Component
    protected MavenProject project;
    @Component
    protected MavenProjectHelper projectHelper;
    @Component
    protected ArtifactHandlerManager artifactHandlerManager;
    @Parameter(defaultValue="maven.")
    protected String propertyPrefix;
    @Parameter(property="localRepository")
    protected ArtifactRepository localRepository;
    @Parameter(defaultValue="false")
    protected boolean exportAntProperties;
    @Parameter
    protected Set<String> exportedAntProperties;
    @Parameter(property="project.remoteProjectRepositories")
    protected List<RemoteRepository> remoteRepositories;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter(property="settings")
    protected Settings settings;
    @Parameter(defaultValue="true")
    protected boolean failOnError;

    public RepositorySystem getSystem() {
        return this.system;
    }

    public DefaultRepositorySystemSession getSession() {
        if (this.session == null) {
            this.session = new DefaultRepositorySystemSession(this.repositorySystemSession);
            DependencySelector depSelector = this.session.getDependencySelector();
            this.getLog().debug((CharSequence)("Replace DependencySelector " + depSelector));
            AndDependencySelector depFilter = new AndDependencySelector(new DependencySelector[]{new ScopeDependencySelector("provided", "test"), new OptionalDependencySelector(), new ExclusionDependencySelector()});
            this.session.setDependencySelector((DependencySelector)depFilter);
            this.session.setConfigProperty("aether.conflictResolver.verbose", (Object)false);
            this.session.setConfigProperty("aether.dependencyManager.verbose", (Object)true);
            this.session.setReadOnly();
            this.repositorySystemSession = this.session;
        }
        return this.session;
    }

    public ArtifactHandlerManager getArtifactHandlerManager() {
        return this.artifactHandlerManager;
    }

    public List<RemoteRepository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public String getEncoding() {
        if (StringUtils.isEmpty((String)this.encoding)) {
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            this.encoding = ReaderFactory.FILE_ENCODING;
        }
        return this.encoding;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        instance.set(this);
        this.settings.setInteractiveMode(false);
        AntClient ant = new AntClient(this.getLog());
        ant.getProject().setBaseDir(this.project.getBasedir());
        try {
            this.setAntReferencesFromMaven(ant.getProject());
        }
        catch (DependencyResolutionRequiredException | BuildException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        this.setAntPropertiesFromMaven(ant.getProject());
        if (this.buildFile != null && this.buildFiles != null && this.buildFiles.length > 0) {
            throw new MojoExecutionException("The configuration parameters 'buildFile' and 'buildFiles' cannot both be used.");
        }
        if (this.buildFiles == null || this.buildFiles.length == 0) {
            if (this.buildFile == null) {
                this.buildFile = new File("build.xml");
            }
            this.buildFiles = new File[]{this.buildFile};
        }
        if (this.target != null && this.targets != null && this.targets.length > 0) {
            throw new MojoExecutionException("The configuration parameters 'target' and 'targets' cannot both be used.");
        }
        if ((this.targets == null || this.targets.length == 0) && this.target != null) {
            this.targets = new String[]{this.target};
        }
        for (File file : this.buildFiles) {
            try {
                if (this.targets != null && this.targets.length > 0) {
                    ant.run(file, Arrays.asList(this.targets));
                } else {
                    ant.run(file);
                }
                if (!this.exportAntProperties) continue;
                this.setMavenPropertiesFromAnt(ant);
            }
            catch (BuildException e) {
                String errMsg = String.format("Error occurred while running %s@%d:%d\n%s", file.getPath(), e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), e.getMessage());
                if (this.failOnError) {
                    throw new MojoExecutionException(errMsg, (Exception)((Object)e));
                }
                this.getLog().error((CharSequence)errMsg, (Throwable)e);
            }
        }
    }

    public Graph newGraph() {
        this.graph = new Graph();
        this.graph.addRootNode(this.project);
        this.expandGraph(this.graph);
        return this.graph;
    }

    public Graph newGraph(String key) {
        this.graph = new Graph();
        this.graph.addRootNode(key);
        this.expandGraph(this.graph);
        return this.graph;
    }

    protected void expandGraph(Graph newGraph) {
        int depth = Expand.readExpand(this.expand);
        if (depth > 0) {
            newGraph.resolveDependencies(new TrueFilter(), depth);
        }
    }

    protected void setMavenPropertiesFromAnt(AntClient ant) {
        Hashtable antProps = ant.getProject().getUserProperties();
        Set<Object> keySet = this.exportedAntProperties != null && this.exportedAntProperties.size() > 0 ? this.exportedAntProperties : antProps.keySet();
        for (String key : keySet) {
            if (!(antProps.get(key) instanceof String)) continue;
            this.project.getProperties().setProperty(key, (String)antProps.get(key));
        }
    }

    protected void setAntReferencesFromMaven(Project antProject) throws BuildException, DependencyResolutionRequiredException {
        Path p = new Path(antProject);
        p.setPath(StringUtils.join(this.project.getCompileClasspathElements().iterator(), (String)File.pathSeparator));
        antProject.addReference(this.propertyPrefix + "compile.classpath", (Object)p);
        p = new Path(antProject);
        p.setPath(StringUtils.join(this.project.getRuntimeClasspathElements().iterator(), (String)File.pathSeparator));
        antProject.addReference(this.propertyPrefix + "runtime.classpath", (Object)p);
        p = new Path(antProject);
        p.setPath(StringUtils.join(this.project.getTestClasspathElements().iterator(), (String)File.pathSeparator));
        antProject.addReference(this.propertyPrefix + "test.classpath", (Object)p);
        antProject.addReference(this.propertyPrefix + "project", (Object)this.project);
        antProject.addReference(this.propertyPrefix + "project.helper", (Object)this.projectHelper);
        antProject.addReference(this.propertyPrefix + "local.repository", (Object)this.localRepository);
    }

    protected void setAntPropertiesFromMaven(Project antProject) {
        for (String key : this.project.getProperties().stringPropertyNames()) {
            antProject.setUserProperty(key, this.project.getProperties().getProperty(key));
        }
        antProject.setProperty(this.propertyPrefix + "basedir", this.project.getBasedir().getPath());
        antProject.setProperty(this.propertyPrefix + "project.groupId", this.project.getGroupId());
        antProject.setProperty(this.propertyPrefix + "project.artifactId", this.project.getArtifactId());
        antProject.setProperty(this.propertyPrefix + "project.version", this.project.getVersion());
        antProject.setProperty(this.propertyPrefix + "project.name", this.project.getName());
        antProject.setProperty(this.propertyPrefix + "project.description", this.project.getDescription());
        antProject.setProperty(this.propertyPrefix + "project.packaging", this.project.getPackaging());
        antProject.setProperty(this.propertyPrefix + "project.id", this.project.getId());
        antProject.setProperty(this.propertyPrefix + "project.build.directory", this.project.getBuild().getDirectory());
        antProject.setProperty(this.propertyPrefix + "project.build.outputDirectory", this.project.getBuild().getOutputDirectory());
        antProject.setProperty(this.propertyPrefix + "project.build.testOutputDirectory", this.project.getBuild().getTestOutputDirectory());
        antProject.setProperty(this.propertyPrefix + "project.build.sourceDirectory", this.project.getBuild().getSourceDirectory());
        antProject.setProperty(this.propertyPrefix + "project.build.testSourceDirectory", this.project.getBuild().getTestSourceDirectory());
        antProject.setProperty(this.propertyPrefix + "localRepository", this.localRepository.toString());
        antProject.setProperty(this.propertyPrefix + "settings.localRepository", this.localRepository.getBasedir());
        antProject.setProperty(this.propertyPrefix + "project.build.finalName", this.project.getBuild().getFinalName());
        antProject.setProperty(this.propertyPrefix + "offline", this.settings.isOffline() ? "-o" : "");
        this.antProfileManager = new AntProfileManager();
        List<Profile> profiles = this.getActiveProfiles();
        for (Profile profile : profiles) {
            this.antProfileManager.activateProfile(profile.getId(), true);
            antProject.setProperty(this.propertyPrefix + "profile." + profile.getId(), "true");
            for (String key : profile.getProperties().stringPropertyNames()) {
                antProject.setUserProperty(key, profile.getProperties().getProperty(key));
            }
        }
        for (String key : System.getProperties().stringPropertyNames()) {
            antProject.setUserProperty(key, System.getProperty(key));
        }
    }

    public List<Profile> getActiveProfiles() {
        return this.project.getActiveProfiles();
    }

    public MavenProject getProject() {
        return this.project;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public Graph getGraph() {
        if (this.graph == null) {
            this.graph = this.newGraph();
        }
        return this.graph;
    }

    public AntProfileManager getAntProfileManager() {
        return this.antProfileManager;
    }

    public static AntBuildMojo getInstance() {
        return instance.get();
    }
}

