/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.nuxeo.build.maven.graph.DependencyUtils;

public class ArtifactDescriptor {
    protected static final String KEY_PATTERN = "(?<groupId>[^: ]+):(?<artifactId>[^: ]+)(?::(?<version>[^: ]*)(?::(?<type>[^: ]*)(?::(?<classifier>[^: ]*)(?::(?<scope>[^: ]*))?)?)?)?";
    public String groupId = null;
    public String artifactId = null;
    public String version = null;
    public String type = "jar";
    public String classifier = null;
    public String scope = "compile";
    protected final Pattern adPattern = Pattern.compile("(?<groupId>[^: ]+):(?<artifactId>[^: ]+)(?::(?<version>[^: ]*)(?::(?<type>[^: ]*)(?::(?<classifier>[^: ]*)(?::(?<scope>[^: ]*))?)?)?)?");

    public static ArtifactDescriptor emptyDescriptor() {
        ArtifactDescriptor ad = new ArtifactDescriptor();
        ad.scope = null;
        ad.type = null;
        return ad;
    }

    private ArtifactDescriptor() {
    }

    public ArtifactDescriptor(String groupId, String artifactId, String version, String type, String classifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.classifier = classifier;
    }

    public ArtifactDescriptor(String key) {
        Matcher m = this.adPattern.matcher(key);
        if (!m.matches()) {
            throw new IllegalArgumentException(String.format("Invalid key '%s', expected format is '%s'", key, "<groupId>:<artifactId>[:<version>[:<type>[:<classifier>[:<scope>]]]]"));
        }
        this.groupId = m.group("groupId");
        this.artifactId = m.group("artifactId");
        if (m.group("version") != null && !m.group("version").isEmpty()) {
            this.version = m.group("version");
        }
        if (m.group("type") != null && !m.group("type").isEmpty()) {
            this.type = m.group("type");
        }
        if (m.group("classifier") != null && !m.group("classifier").isEmpty()) {
            this.classifier = m.group("classifier");
        }
        if (m.group("scope") != null && !m.group("scope").isEmpty()) {
            this.scope = m.group("scope");
        }
    }

    public String getNodeKeyPattern() {
        if (this.groupId != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.groupId);
            if (this.artifactId != null) {
                buf.append(':').append(this.artifactId);
                if (this.version != null) {
                    buf.append(':').append(this.version);
                    if (this.type != null) {
                        buf.append(':').append(this.type);
                    }
                }
            }
            return buf.toString();
        }
        return null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.groupId).append(':').append(this.artifactId);
        buf.append(':').append(this.version);
        buf.append(':').append(this.type);
        buf.append(':');
        if (this.classifier != null) {
            buf.append(this.classifier);
        }
        buf.append(':').append(this.scope);
        return buf.toString();
    }

    public org.apache.maven.artifact.Artifact getMavenArtifact() {
        Artifact aetherArtifact = this.getAetherArtifact();
        return DependencyUtils.aetherToMaven(aetherArtifact, this.scope);
    }

    public Artifact getAetherArtifact() {
        return this.getDependency().getArtifact();
    }

    public Dependency getDependency() {
        return new Dependency((Artifact)new DefaultArtifact(this.groupId, this.artifactId, this.classifier, this.type, this.version), this.scope);
    }
}

