/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.surefire.suite.RunResult;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.nuxeo.build.maven.AntBuildMojo;

@Mojo(name="integration-test", defaultPhase=LifecyclePhase.INTEGRATION_TEST, threadSafe=true, requiresProject=true, requiresDependencyResolution=ResolutionScope.TEST)
public class IntegrationTestMojo
extends AntBuildMojo {
    private static final String FAILSAFE_IN_PROGRESS_CONTEXT_KEY = "failsafe-in-progress";
    @Deprecated
    @Parameter(defaultValue="true", property="maven.test.failure.ignore")
    protected boolean testFailureIgnore;
    @Parameter(defaultValue="${project.build.directory}/nxtools-reports/nxtools-summary.xml", required=true)
    protected File summaryFile;
    @Parameter(property="skipITs")
    protected boolean skipITs;
    @Parameter(defaultValue="${project.reporting.outputEncoding}")
    protected String reportingEncoding;

    @Override
    public String getEncoding() {
        if (StringUtils.isEmpty((String)this.reportingEncoding)) {
            this.reportingEncoding = super.getEncoding();
        }
        return this.reportingEncoding;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipITs) {
            this.getLog().info((CharSequence)"Tests are skipped.");
            return;
        }
        RunResult result = RunResult.noTestsRun();
        this.failOnError = true;
        try {
            super.execute();
            result.aggregate(new RunResult(this.buildFiles.length, 0, 0, 0));
        }
        catch (MojoExecutionException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            result = RunResult.failure((RunResult)result, (Exception)((Object)e));
        }
        this.writeSummary(result);
    }

    private void writeSummary(RunResult summary) throws MojoExecutionException {
        if (!this.summaryFile.getParentFile().isDirectory()) {
            this.summaryFile.getParentFile().mkdirs();
        }
        OutputStream fout = null;
        InputStream fin = null;
        try {
            Object token = this.getPluginContext().get(FAILSAFE_IN_PROGRESS_CONTEXT_KEY);
            summary.writeSummary(this.summaryFile, token != null, this.getEncoding());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        finally {
            IOUtil.close(fin);
            IOUtil.close(fout);
        }
        this.getPluginContext().put(FAILSAFE_IN_PROGRESS_CONTEXT_KEY, FAILSAFE_IN_PROGRESS_CONTEXT_KEY);
    }
}

