/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.SurefireReportParameters;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.surefire.suite.RunResult;
import org.codehaus.plexus.util.StringUtils;
import org.nuxeo.build.maven.AntBuildMojo;

@Mojo(name="verify", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true, requiresProject=true, requiresDependencyResolution=ResolutionScope.TEST)
public class VerifyMojo
extends AntBuildMojo
implements SurefireReportParameters {
    @Parameter(defaultValue="${project.build.directory}/nxtools-reports/nxtools-summary.xml", required=true)
    protected File summaryFile;
    @Parameter
    protected File[] summaryFiles;
    @Parameter(property="skipITs")
    protected boolean skipITs;
    @Parameter(defaultValue="${project.reporting.outputEncoding}")
    protected String reportingEncoding;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false")
    protected boolean testFailureIgnore;
    @Parameter(property="failIfNoTests")
    protected Boolean failIfNoTests;

    @Override
    public String getEncoding() {
        if (StringUtils.isEmpty((String)this.reportingEncoding)) {
            this.reportingEncoding = super.getEncoding();
        }
        return this.reportingEncoding;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        RunResult summary;
        if (this.isSkip() || this.isSkipTests() || this.isSkipExec()) {
            this.getLog().info((CharSequence)"Tests are skipped.");
            return;
        }
        if (!this.getTestClassesDirectory().exists()) {
            if (this.getFailIfNoTests() != null && this.getFailIfNoTests().booleanValue()) {
                throw new MojoFailureException("No tests to run!");
            }
            this.getLog().info((CharSequence)"No tests to run.");
            return;
        }
        try {
            summary = !this.summaryFile.isFile() && this.summaryFiles != null ? RunResult.noTestsRun() : this.readSummary(this.getEncoding(), this.summaryFile);
            if (this.summaryFiles != null) {
                for (File file : this.summaryFiles) {
                    summary = summary.aggregate(this.readSummary(this.getEncoding(), file));
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        SurefireHelper.reportExecution((SurefireReportParameters)this, (RunResult)summary, (Log)this.getLog());
    }

    private RunResult readSummary(String sumEncoding, File sumFile) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(sumFile));){
            RunResult runResult = RunResult.fromInputStream((InputStream)in, (String)sumEncoding);
            return runResult;
        }
    }

    public boolean isSkipTests() {
        return this.skipITs;
    }

    public void setSkipTests(boolean skipTests) {
        throw new UnsupportedOperationException();
    }

    public boolean isSkipExec() {
        return this.skipITs;
    }

    public void setSkipExec(boolean skipExec) {
        throw new UnsupportedOperationException();
    }

    public boolean isSkip() {
        return this.skipITs;
    }

    public void setSkip(boolean skip) {
        throw new UnsupportedOperationException();
    }

    public boolean isTestFailureIgnore() {
        return this.testFailureIgnore;
    }

    public void setTestFailureIgnore(boolean testFailureIgnore) {
        throw new UnsupportedOperationException();
    }

    public File getBasedir() {
        return this.project.getBasedir();
    }

    public void setBasedir(File basedir) {
        throw new UnsupportedOperationException();
    }

    public File getTestClassesDirectory() {
        return new File(this.project.getBuild().getTestOutputDirectory());
    }

    public void setTestClassesDirectory(File testClassesDirectory) {
        throw new UnsupportedOperationException();
    }

    public File getReportsDirectory() {
        return this.summaryFile.getParentFile();
    }

    public void setReportsDirectory(File reportsDirectory) {
        throw new UnsupportedOperationException();
    }

    public Boolean getFailIfNoTests() {
        return this.failIfNoTests;
    }

    public void setFailIfNoTests(Boolean failIfNoTests) {
        throw new UnsupportedOperationException();
    }
}

