/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.nuxeo.build.maven.ArtifactDescriptor;
import org.nuxeo.build.maven.filter.AbstractFilter;
import org.nuxeo.build.maven.filter.ArtifactIdFilter;
import org.nuxeo.build.maven.filter.ClassifierFilter;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.filter.GroupIdFilter;
import org.nuxeo.build.maven.filter.ScopeFilter;
import org.nuxeo.build.maven.filter.TypeFilter;
import org.nuxeo.build.maven.filter.VersionFilter;

public class AncestorFilter
extends AbstractFilter {
    protected ArtifactDescriptor ad;
    protected List<Filter> filters;

    public AncestorFilter(String pattern) {
        this.ad = new ArtifactDescriptor(pattern);
        this.filters = new ArrayList<Filter>();
        if (this.ad.groupId != null && !this.ad.groupId.equals("*")) {
            this.addFilter(new GroupIdFilter(this.ad.groupId));
        }
        if (this.ad.artifactId != null && !this.ad.artifactId.equals("*")) {
            this.addFilter(new ArtifactIdFilter(this.ad.artifactId));
        }
        if (this.ad.version != null && !this.ad.version.equals("*")) {
            this.addFilter(new VersionFilter(this.ad.version));
        }
        if (this.ad.type != null && !this.ad.type.equals("*")) {
            this.addFilter(new TypeFilter(this.ad.type));
        }
        if (this.ad.classifier != null && !this.ad.classifier.equals("*")) {
            this.addFilter(new ClassifierFilter(this.ad.classifier));
        }
        if (this.ad.scope != null && !this.ad.scope.equals("*")) {
            this.addFilter(new ScopeFilter(this.ad.scope));
        }
    }

    protected void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    @Override
    public boolean accept(Artifact artifact) {
        throw new UnsupportedOperationException("Ancestor folder cannot be applied on artifact objects");
    }

    public boolean accept(DependencyNode node, List<DependencyNode> parents) {
        for (DependencyNode parent : parents) {
            if (!this.accept(parent)) continue;
            return true;
        }
        return this.result(false, node.toString());
    }

    protected boolean accept(DependencyNode parent) {
        for (Filter filter : this.filters) {
            if (filter.accept(parent, Collections.emptyList())) continue;
            return false;
        }
        return true;
    }
}

