/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.filter;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nuxeo.build.ant.AntClient;
import org.nuxeo.build.maven.ArtifactDescriptor;
import org.nuxeo.build.maven.filter.AbstractFilter;
import org.nuxeo.build.maven.filter.ArtifactIdFilter;
import org.nuxeo.build.maven.filter.ClassifierFilter;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.filter.GroupIdFilter;
import org.nuxeo.build.maven.filter.NotFilter;
import org.nuxeo.build.maven.filter.ScopeFilter;
import org.nuxeo.build.maven.filter.TypeFilter;
import org.nuxeo.build.maven.filter.VersionFilter;

public abstract class CompositeFilter
extends AbstractFilter {
    protected List<Filter> filters = new ArrayList<Filter>();

    public CompositeFilter() {
    }

    public CompositeFilter(List<Filter> filters) {
        this.filters.addAll(filters);
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public void removeFilter(Filter filter) {
        this.filters.remove(filter);
    }

    public void addFilters(List<Filter> filtersToAdd) {
        this.filters.addAll(filtersToAdd);
    }

    public void addFilters(Filter ... filtersToAdd) {
        this.filters.addAll(Arrays.asList(filtersToAdd));
    }

    public void removeFilters(List<Filter> filters) {
        this.filters.removeAll(filters);
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public boolean isEmpty() {
        return this.filters.isEmpty();
    }

    public void addFiltersFromPattern(String pattern) {
        if (pattern != null) {
            this.addFiltersFromDescriptor(new ArtifactDescriptor(pattern));
        }
    }

    public void addFiltersFromDescriptor(ArtifactDescriptor ad) {
        if (ad.groupId != null && !ad.groupId.equals("*")) {
            this.addFilter(GroupIdFilter.class, ad.groupId);
        }
        if (ad.artifactId != null && !ad.artifactId.equals("*")) {
            this.addFilter(ArtifactIdFilter.class, ad.artifactId);
        }
        if (ad.version != null && !ad.version.equals("*")) {
            this.addFilter(VersionFilter.class, ad.version);
        }
        if (ad.type != null && !ad.type.equals("*")) {
            this.addFilter(TypeFilter.class, ad.type);
        }
        if (ad.classifier != null && !ad.classifier.equals("*")) {
            this.addFilter(ClassifierFilter.class, ad.classifier);
        }
        if (ad.scope != null && !ad.scope.equals("*")) {
            this.addFilter(ScopeFilter.class, ad.scope);
        }
    }

    public static Filter compact(CompositeFilter filter) {
        Filter result = filter;
        CompositeFilter cf = filter;
        if (cf != null && cf.filters.size() == 1 && (result = cf.filters.get(0)) instanceof CompositeFilter) {
            result = CompositeFilter.compact(result);
        }
        return result;
    }

    public void addFilter(Class<? extends Filter> filterClass, String pattern) {
        if (pattern == null) {
            return;
        }
        Constructor<? extends Filter> filterConstructor = null;
        try {
            filterConstructor = filterClass.getConstructor(String.class);
            if (pattern.startsWith("!")) {
                this.addFilter(new NotFilter(filterConstructor.newInstance(pattern.substring(1))));
            } else {
                this.addFilter(filterConstructor.newInstance(pattern));
            }
        }
        catch (SecurityException e) {
            AntClient.getInstance().log("Couldn't get constructor for " + filterClass, (Throwable)e, 0);
        }
        catch (NoSuchMethodException e) {
            AntClient.getInstance().log("Couldn't get constructor for " + filterClass, (Throwable)e, 0);
        }
        catch (IllegalArgumentException e) {
            AntClient.getInstance().log("Couldn't call constructor for " + filterClass, (Throwable)e, 0);
        }
        catch (InstantiationException e) {
            AntClient.getInstance().log("Couldn't call constructor for " + filterClass, (Throwable)e, 0);
        }
        catch (IllegalAccessException e) {
            AntClient.getInstance().log("Couldn't call constructor for " + filterClass, (Throwable)e, 0);
        }
        catch (InvocationTargetException e) {
            AntClient.getInstance().log("Couldn't call constructor for " + filterClass, (Throwable)e, 0);
        }
    }
}

