/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.filter;

import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.nuxeo.build.maven.filter.AbstractFilter;
import org.nuxeo.build.maven.filter.SegmentMatch;

public class GroupIdFilter
extends AbstractFilter {
    protected SegmentMatch matcher;

    public String toString() {
        return "" + this.getClass() + " [" + this.matcher + "]";
    }

    public GroupIdFilter(String pattern) {
        this(SegmentMatch.parse(pattern));
    }

    public GroupIdFilter(SegmentMatch matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean accept(org.apache.maven.artifact.Artifact artifact) {
        return this.result(this.matcher.match(artifact.getGroupId()), artifact.toString());
    }

    public boolean accept(DependencyNode node, List<DependencyNode> parents) {
        Artifact artifact = node.getArtifact();
        if (artifact == null) {
            return this.result(this.matcher == SegmentMatch.ANY, node.toString());
        }
        return this.result(this.matcher.match(artifact.getGroupId()), node.toString());
    }
}

