/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.filter;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.nuxeo.build.maven.filter.AbstractFilter;
import org.nuxeo.build.maven.filter.SegmentMatch;

public class ScopeFilter
extends AbstractFilter {
    protected SegmentMatch matcher;

    public String toString() {
        return "" + this.getClass() + " [" + this.matcher + "]";
    }

    public ScopeFilter(String pattern) {
        this(SegmentMatch.parse(pattern));
    }

    public ScopeFilter(SegmentMatch matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean accept(Artifact artifact) {
        return this.result(this.match(artifact.getScope()), artifact.toString());
    }

    public boolean accept(DependencyNode node, List<DependencyNode> parents) {
        Dependency dependency = node.getDependency();
        if (dependency == null) {
            return this.result(this.matcher == SegmentMatch.ANY, node.toString());
        }
        return this.result(this.match(dependency.getScope()), node.toString());
    }

    private boolean match(String scope) {
        if (scope == null) {
            return this.matcher == SegmentMatch.ANY;
        }
        return this.matcher.match(scope);
    }
}

