/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.graph;

import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.tools.ant.BuildException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.DependencyManagement;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.nuxeo.build.ant.AntClient;
import org.nuxeo.build.maven.AntBuildMojo;
import org.nuxeo.build.maven.filter.Filter;

public class DependencyUtils {
    private DependencyUtils() {
    }

    public static org.apache.maven.artifact.Artifact aetherToMaven(Artifact aetherArtifact, String scope, ArtifactHandler artifactHandler) {
        org.apache.maven.artifact.DefaultArtifact mavenArtifact = new org.apache.maven.artifact.DefaultArtifact(aetherArtifact.getGroupId(), aetherArtifact.getArtifactId(), aetherArtifact.getVersion(), scope, aetherArtifact.getExtension(), aetherArtifact.getClassifier(), artifactHandler);
        mavenArtifact.setFile(aetherArtifact.getFile());
        mavenArtifact.setResolved(aetherArtifact.getFile() != null);
        return mavenArtifact;
    }

    public static org.apache.maven.artifact.Artifact toMavenArtifact(Dependency dependency) {
        return DependencyUtils.aetherToMaven(dependency.getArtifact(), dependency.getScope(), AntBuildMojo.getInstance().getArtifactHandlerManager().getArtifactHandler(dependency.getArtifact().getExtension()));
    }

    public static org.apache.maven.artifact.Artifact aetherToMaven(Artifact aetherArtifact, String scope) {
        return DependencyUtils.aetherToMaven(aetherArtifact, scope, AntBuildMojo.getInstance().getArtifactHandlerManager().getArtifactHandler(aetherArtifact.getExtension()));
    }

    public static Artifact mavenToAether(org.apache.maven.artifact.Artifact artifact) {
        return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType(), artifact.getVersion());
    }

    public static Artifact resolve(Artifact artifact) throws ArtifactResolutionException {
        AntBuildMojo mojo = AntBuildMojo.getInstance();
        return DependencyUtils.resolve(artifact, mojo.getRemoteRepositories());
    }

    public static Artifact resolve(Artifact artifact, List<RemoteRepository> remoteRepositories) throws ArtifactResolutionException {
        AntBuildMojo mojo = AntBuildMojo.getInstance();
        ArtifactResult result = mojo.getSystem().resolveArtifact((RepositorySystemSession)mojo.getSession(), new ArtifactRequest(artifact, remoteRepositories, null));
        artifact = result.getArtifact();
        AntClient.getInstance().log(artifact + " resolved to  " + artifact.getFile(), 4);
        return artifact;
    }

    @Deprecated
    public static void resolve(org.apache.maven.artifact.Artifact artifact) throws ArtifactResolutionException {
        DependencyUtils.resolve(DependencyUtils.mavenToAether(artifact));
    }

    public static Dependency mavenToDependency(org.apache.maven.artifact.Artifact artifact) {
        return new Dependency(DependencyUtils.mavenToAether(artifact), artifact.getScope());
    }

    public static Dependency getManagedDependency(Dependency dependency) {
        AntBuildMojo mojo = AntBuildMojo.getInstance();
        DependencyManagement depMgt = mojo.getSession().getDependencyManager().manageDependency(dependency);
        if (depMgt != null) {
            Artifact artifact;
            if (depMgt.getVersion() != null) {
                artifact = dependency.getArtifact();
                dependency = dependency.setArtifact(artifact.setVersion(depMgt.getVersion()));
            }
            if (depMgt.getProperties() != null) {
                artifact = dependency.getArtifact();
                dependency = dependency.setArtifact(artifact.setProperties(depMgt.getProperties()));
            }
            if (depMgt.getScope() != null) {
                dependency = dependency.setScope(depMgt.getScope());
            }
            if (depMgt.getOptional() != null) {
                dependency = dependency.setOptional(depMgt.getOptional());
            }
            if (depMgt.getExclusions() != null) {
                dependency = dependency.setExclusions(depMgt.getExclusions());
            }
        }
        return dependency;
    }

    public static Artifact setManagedVersion(Artifact artifact) {
        AntBuildMojo mojo = AntBuildMojo.getInstance();
        List managedDeps = AntBuildMojo.getInstance().getProject().getDependencyManagement().getDependencies();
        for (org.apache.maven.model.Dependency dependency : managedDeps) {
            Artifact managedArtifact = RepositoryUtils.toDependency((org.apache.maven.model.Dependency)dependency, (ArtifactTypeRegistry)mojo.getSession().getArtifactTypeRegistry()).getArtifact();
            if (!ArtifactIdUtils.equalsVersionlessId((Artifact)managedArtifact, (Artifact)artifact)) continue;
            artifact = artifact.setVersion(managedArtifact.getVersion());
            AntClient.getInstance().log("Managed version set on " + artifact);
            break;
        }
        return artifact;
    }

    public static Artifact setNewestVersion(Artifact artifact) {
        AntBuildMojo mojo = AntBuildMojo.getInstance();
        artifact = artifact.setVersion("[0,)");
        VersionRangeRequest rangeRequest = new VersionRangeRequest(artifact, AntBuildMojo.getInstance().getRemoteRepositories(), null);
        try {
            VersionRangeResult rangeResult = mojo.getSystem().resolveVersionRange((RepositorySystemSession)mojo.getSession(), rangeRequest);
            AntClient.getInstance().log(String.format("Versions found for %s: %s", artifact, rangeResult.getVersions()), 4);
            artifact = artifact.setVersion(rangeResult.getHighestVersion().toString());
            AntClient.getInstance().log("Highest version found set on " + artifact);
        }
        catch (VersionRangeResolutionException e) {
            AntClient.getInstance().log(e.getMessage(), (Throwable)e, 0);
        }
        return artifact;
    }

    public static DependencyResult resolveDependencies(DependencyNode node, Filter filter, int depth) {
        AntBuildMojo mojo = AntBuildMojo.getInstance();
        AntClient.getInstance().log(String.format("Resolving %s with filter %s and depth %d", node, filter, depth), 4);
        DependencyRequest dependencyRequest = new DependencyRequest(node, (DependencyFilter)filter);
        try {
            DependencyResult result = mojo.getSystem().resolveDependencies((RepositorySystemSession)mojo.getSession(), dependencyRequest);
            AntClient.getInstance().log("Dependency result: " + result, (Throwable)new Error(), 4);
            AntClient.getInstance().log("Dependency exceptions: " + result.getCollectExceptions(), 4);
            return result;
        }
        catch (DependencyResolutionException e) {
            throw new BuildException("Cannot resolve dependency tree for " + node, (Throwable)e);
        }
    }
}

