/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.graph;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.nuxeo.build.ant.AntClient;
import org.nuxeo.build.maven.AntBuildMojo;
import org.nuxeo.build.maven.graph.AbstractDependencyVisitor;

public class FlatPrinterDependencyVisitor
extends AbstractDependencyVisitor {
    protected int format;
    protected OutputStream output;
    protected Set<String> lines = new TreeSet<String>();

    public FlatPrinterDependencyVisitor(OutputStream output, int format, List<String> scopes) {
        super(scopes);
        this.output = output;
        this.format = format;
    }

    @Override
    protected void doVisit(DependencyNode node, boolean newNode) {
        if (newNode) {
            this.print(node);
        }
    }

    protected void print(DependencyNode node) {
        if ("pom".equals(node.getArtifact().getExtension())) {
            return;
        }
        Artifact artifact = node.getArtifact();
        DependencyNode winner = (DependencyNode)node.getData().get("conflict.winner");
        if (winner != null && !ArtifactIdUtils.equalsId((Artifact)artifact, (Artifact)winner.getArtifact())) {
            Artifact w = winner.getArtifact();
            if (ArtifactIdUtils.toVersionlessId((Artifact)artifact).equals(ArtifactIdUtils.toVersionlessId((Artifact)w))) {
                AntClient.getInstance().log(String.format("Ignored conflicting node %s with %s", node, w.getVersion()), 4);
            } else {
                AntClient.getInstance().log(String.format("Ignored conflicting node %s with %s", node, w), 4);
            }
        } else {
            String toString = this.toString(node) + System.getProperty("line.separator");
            this.lines.add(toString);
        }
    }

    public void print() throws UnsupportedEncodingException, IOException {
        for (String line : this.lines) {
            this.output.write(line.getBytes(AntBuildMojo.getInstance().getEncoding()));
        }
    }

    public String toString(DependencyNode node) {
        Artifact artifact = node.getArtifact();
        Dependency dependency = node.getDependency();
        StringBuilder sb = new StringBuilder();
        switch (this.format) {
            case 1: {
                sb.append(artifact.getFile().getName());
                sb.append('=');
            }
            case 0: {
                sb.append(artifact.getGroupId());
                sb.append(':').append(artifact.getArtifactId());
                sb.append(':').append(artifact.getVersion());
                sb.append(':').append(artifact.getExtension());
                sb.append(':').append(artifact.getClassifier());
                sb.append(':').append(dependency.getScope());
                break;
            }
            default: {
                return "Unknown format: " + this.format + "!";
            }
        }
        return sb.toString();
    }
}

