/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.graph;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.artifact.SubArtifact;
import org.nuxeo.build.ant.AntClient;
import org.nuxeo.build.maven.AntBuildMojo;
import org.nuxeo.build.maven.ArtifactDescriptor;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.graph.DependencyUtils;
import org.nuxeo.build.maven.graph.Node;

public class Graph {
    public final TreeMap<String, Node> nodes = new TreeMap();
    public final List<Node> roots = new LinkedList<Node>();
    private AntBuildMojo mojo = AntBuildMojo.getInstance();

    public List<Node> getRoots() {
        return this.roots;
    }

    public Collection<Node> getNodes() {
        return this.nodes.values();
    }

    public Node findFirst(String pattern) {
        return this.findFirst(pattern, false);
    }

    public Node findFirst(String pattern, boolean stopIfNotUnique) {
        SortedMap<String, Node> map = this.nodes.subMap(pattern + ':', pattern + ';');
        int size = map.size();
        if (size == 0) {
            return null;
        }
        if (stopIfNotUnique && size > 1) {
            throw new BuildException(String.format("Pattern '%s' cannot be resolved to a unique node. Matching nodes are: %s", pattern, map.values()));
        }
        return (Node)map.get(map.firstKey());
    }

    public Collection<Node> find(String pattern) {
        SortedMap<String, Node> map = this.nodes.subMap(pattern + ':', pattern + ';');
        return map.values();
    }

    public Node addRootNode(MavenProject pom) {
        org.apache.maven.artifact.Artifact artifact = pom.getArtifact();
        Node node = this.nodes.get(Node.genNodeId(artifact));
        if (node == null) {
            Artifact aetherArtifact = DependencyUtils.mavenToAether(artifact);
            SubArtifact pomArtifact = new SubArtifact(aetherArtifact, null, "pom", pom.getFile());
            Dependency dependency = new Dependency((Artifact)pomArtifact, artifact.getScope());
            node = this.collectRootNode(dependency);
        }
        return this.addRootNode(node);
    }

    public Node addRootNode(String key) {
        ArtifactDescriptor ad = new ArtifactDescriptor(key);
        return this.addRootNode(ad.getDependency());
    }

    public Node addRootNode(Dependency dependency) {
        Node node = this.nodes.get(Node.genNodeId(dependency));
        if (node == null) {
            node = this.collectRootNode(dependency);
        } else {
            this.roots.add(node);
            AntClient.getInstance().log("Added root node: " + node, 4);
        }
        return node;
    }

    public Node addRootNode(Node node) {
        if (!this.nodes.containsKey(node.id)) {
            node = this.collectRootNode(node.getDependency());
        } else if (!this.roots.contains(node)) {
            this.roots.add(node);
            AntClient.getInstance().log("Added root node: " + node, 4);
        }
        return this.nodes.get(node.id);
    }

    private Node collectRootNode(Dependency dependency) {
        DependencyNode root = this.collectDependencies(dependency);
        Node node = new Node(this, root);
        this.roots.add(node);
        AntClient.getInstance().log("Added root node: " + node, 4);
        this.addNode(node);
        return node;
    }

    private Node resolveRootNode(Node root, Filter filter, int depth) {
        if (!filter.accept(root, null)) {
            return null;
        }
        DependencyResult result = DependencyUtils.resolveDependencies(root, filter, depth);
        Node node = new Node(this, result.getRoot());
        this.roots.add(node);
        AntClient.getInstance().log("Added resolved root node: " + node, 4);
        this.addNode(node);
        return node;
    }

    private void addNode(Node node) {
        this.nodes.put(node.getId(), node);
        AntClient.getInstance().log("Added node: " + node, 4);
        String scope = node.getDependency().getScope();
        ArrayList<DependencyNode> removes = new ArrayList<DependencyNode>();
        for (DependencyNode child : node.getChildren()) {
            String childScope = child.getDependency().getScope();
            Node childNode = new Node(this, child);
            if (!this.roots.contains(node) && !this.nodes.containsKey(childNode.getId()) && ("test".equals(scope) && !"compile".equals(childScope) && !"runtime".equals(childScope) || !"test".equals(scope) && "test".equals(childScope))) {
                AntClient.getInstance().log("Unexpected child node: " + child + " for " + node, 1);
                removes.add(child);
                continue;
            }
            childNode.addParent(node);
            this.addNode(childNode);
        }
        node.getChildren().removeAll(removes);
    }

    public Node findNode(ArtifactDescriptor ad) {
        String key = ad.getNodeKeyPattern();
        Collection<Node> nodesToParse = null;
        nodesToParse = key == null ? this.getNodes() : this.find(key);
        Node returnNode = null;
        for (Node node : nodesToParse) {
            org.apache.maven.artifact.Artifact artifact = node.getMavenArtifact();
            if (ad.artifactId != null && !ad.artifactId.equals(artifact.getArtifactId()) || ad.groupId != null && !ad.groupId.equals(artifact.getGroupId()) || ad.version != null && !ad.version.equals(artifact.getVersion()) || ad.type != null && !ad.type.equals(artifact.getType())) continue;
            try {
                if (returnNode != null && artifact.getSelectedVersion().compareTo((Object)returnNode.getMavenArtifact().getSelectedVersion()) < 0) {
                    continue;
                }
            }
            catch (OverConstrainedVersionException e) {
                this.mojo.getLog().error((CharSequence)("Versions comparison failed on " + artifact), (Throwable)e);
            }
            returnNode = node;
        }
        return returnNode;
    }

    public DependencyNode collectDependencies(Dependency dependency) {
        AntClient.getInstance().log(String.format("Collecting " + dependency, new Object[0]), 4);
        try {
            CollectRequest collectRequest = new CollectRequest(dependency, this.mojo.getRemoteRepositories());
            CollectResult result = this.mojo.getSystem().collectDependencies((RepositorySystemSession)this.mojo.getSession(), collectRequest);
            DependencyNode node = result.getRoot();
            AntClient.getInstance().log("Collect result: " + result, 4);
            AntClient.getInstance().log("Collect exceptions: " + result.getExceptions(), 4);
            AntClient.getInstance().log("Direct dependencies: " + String.valueOf(node.getChildren()), 4);
            return node;
        }
        catch (DependencyCollectionException e) {
            throw new BuildException("Cannot collect dependency tree for " + dependency, (Throwable)e);
        }
    }

    public void resolveDependencies(Filter filter, int depth) {
        LinkedList<Node> oldRoots = new LinkedList<Node>(this.roots);
        this.roots.clear();
        this.nodes.clear();
        for (Node root : oldRoots) {
            this.resolveRootNode(root, filter, depth);
        }
    }

    protected void tryResolutionOnLocalBaseVersion(org.apache.maven.artifact.Artifact artifact, ArtifactNotFoundException e) throws ArtifactNotFoundException {
        String resolvedVersion = artifact.getVersion();
        artifact.updateVersion(artifact.getBaseVersion(), this.mojo.getLocalRepository());
        File localFile = new File(this.mojo.getLocalRepository().getBasedir(), this.mojo.getLocalRepository().pathOf(artifact));
        if (!localFile.exists()) {
            artifact.updateVersion(resolvedVersion, this.mojo.getLocalRepository());
            this.mojo.getLog().warn((CharSequence)("Cannot resolve " + artifact), (Throwable)e);
            throw e;
        }
        this.mojo.getLog().warn((CharSequence)String.format("Couldn't resolve %s, fallback on local install of unique version %s.", resolvedVersion, artifact.getBaseVersion()));
        artifact.setResolved(true);
    }

    public Node getNode(Dependency dependency) {
        return this.nodes.get(Node.genNodeId(dependency));
    }
}

