/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.nuxeo.build.ant.artifact.ArtifactFile;
import org.nuxeo.build.ant.artifact.ArtifactSetParser;
import org.nuxeo.build.ant.artifact.Excludes;
import org.nuxeo.build.ant.artifact.Expand;
import org.nuxeo.build.ant.artifact.Includes;
import org.nuxeo.build.maven.MavenClientFactory;
import org.nuxeo.build.maven.filter.AncestorFilter;
import org.nuxeo.build.maven.filter.AndFilter;
import org.nuxeo.build.maven.filter.ArtifactIdFilter;
import org.nuxeo.build.maven.filter.ClassifierFilter;
import org.nuxeo.build.maven.filter.CompositeFilter;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.filter.GroupIdFilter;
import org.nuxeo.build.maven.filter.IsOptionalFilter;
import org.nuxeo.build.maven.filter.ScopeFilter;
import org.nuxeo.build.maven.filter.TypeFilter;
import org.nuxeo.build.maven.filter.VersionFilter;
import org.nuxeo.build.maven.graph.Edge;
import org.nuxeo.build.maven.graph.Graph;
import org.nuxeo.build.maven.graph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactSet
extends DataType
implements ResourceCollection {
    public AndFilter filter = new AndFilter();
    public String id;
    public File src;
    public Expand expand;
    public List<ArtifactFile> artifacts;
    public List<ArtifactSet> artifactSets;
    public Includes includes;
    public Excludes excludes;
    protected Collection<Node> nodes;

    public void setGroupId(String groupId) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.filter.addFilter(new GroupIdFilter(groupId));
    }

    public void setArtifactId(String artifactId) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.filter.addFilter(new ArtifactIdFilter(artifactId));
    }

    public void setVersion(String version) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.filter.addFilter(new VersionFilter(version));
    }

    public void setClassifier(String classifier) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.filter.addFilter(new ClassifierFilter(classifier));
    }

    public void setType(String type) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.filter.addFilter(new TypeFilter(type));
    }

    public void setScope(String scope) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.filter.addFilter(new ScopeFilter(scope));
    }

    public void setOptional(boolean isOptional) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.filter.addFilter(new IsOptionalFilter(isOptional));
    }

    public void setPattern(String pattern) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.filter.addFiltersFromPattern(pattern);
    }

    public void setAncestor(String ancestor) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.filter.addFilter(new AncestorFilter(ancestor));
    }

    public void setId(String id) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.id = id;
    }

    public void setSrc(File importFile) {
        this.src = importFile;
    }

    public void addExpand(Expand expand) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.expand = expand;
    }

    public void addArtifact(ArtifactFile artifact) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.artifacts == null) {
            this.artifacts = new ArrayList<ArtifactFile>();
        }
        this.artifacts.add(artifact);
    }

    public void addArtifactSet(ArtifactSet set) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.artifactSets == null) {
            this.artifactSets = new ArrayList<ArtifactSet>();
        }
        this.artifactSets.add(set);
    }

    public void addIncludes(Includes includes) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.includes != null) {
            throw new BuildException("Found an Includes that is defined more than once in an artifactSet");
        }
        this.includes = includes;
    }

    public void addExcludes(Excludes excludes) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.excludes != null) {
            throw new BuildException("Found an Excludes that is defined more than once in an artifactSet");
        }
        this.excludes = excludes;
    }

    public void setRefid(Reference ref) {
        super.setRefid(ref);
    }

    protected ArtifactSet getRef(Project p) {
        return (ArtifactSet)((Object)this.getCheckedRef(p));
    }

    protected List<Node> createInputNodeList() {
        if (this.includes == null && this.excludes == null) {
            return new ArrayList<Node>();
        }
        final AndFilter ieFilter = new AndFilter();
        if (this.includes != null) {
            ieFilter.addFilter(this.includes.getFilter());
        }
        if (this.excludes != null) {
            ieFilter.addFilter(this.excludes.getFilter());
        }
        return new ArrayList<Node>(){
            private static final long serialVersionUID = 1L;
            Filter f;
            {
                this.f = CompositeFilter.compact(ieFilter);
            }

            @Override
            public boolean add(Node node) {
                if (!this.f.accept(node.getArtifact())) {
                    return false;
                }
                return super.add(node);
            }

            @Override
            public boolean addAll(Collection<? extends Node> c) {
                for (Node node : c) {
                    if (!this.f.accept(node.getArtifact())) continue;
                    super.add(node);
                }
                return true;
            }
        };
    }

    protected Filter buildFilter() {
        AndFilter f = new AndFilter();
        if (!this.filter.isEmpty()) {
            f.addFilters(this.filter.getFilters());
        }
        if (this.includes != null) {
            f.addFilter(this.includes.getFilter());
        }
        if (this.excludes != null) {
            f.addFilter(this.excludes.getFilter());
        }
        return f.isEmpty() ? Filter.ANY : CompositeFilter.compact(f);
    }

    protected Collection<Node> computeNodes() {
        Collection<Node> roots;
        block14: {
            Graph graph = MavenClientFactory.getInstance().getGraph();
            Filter finalFilter = this.buildFilter();
            roots = new ArrayList<Node>();
            if (this.src != null) {
                this.collectImportedNodes(roots);
            }
            if (this.artifacts != null) {
                for (ArtifactFile artifactFile : this.artifacts) {
                    roots.add(artifactFile.getNode());
                }
            }
            if (this.artifactSets != null) {
                for (ArtifactSet artifactSet : this.artifactSets) {
                    roots.addAll(artifactSet.getNodes());
                }
            }
            if (roots.isEmpty()) {
                roots = graph.getNodes();
            }
            if (finalFilter != Filter.ANY) {
                ArrayList<Node> result = new ArrayList<Node>();
                for (Node node : roots) {
                    if (MavenClientFactory.getLog().isDebugEnabled()) {
                        MavenClientFactory.getLog().debug("Filtering - " + node + " ...");
                    }
                    if (finalFilter.accept(node)) {
                        result.add(node);
                        if (!MavenClientFactory.getLog().isDebugEnabled()) continue;
                        MavenClientFactory.getLog().debug("Filtering - accepted " + node);
                        continue;
                    }
                    if (!MavenClientFactory.getLog().isDebugEnabled()) continue;
                    MavenClientFactory.getLog().debug("Filtering - refused " + node);
                }
                roots = result;
            }
            if (this.expand == null) break block14;
            ArrayList<Node> nodes = new ArrayList<Node>();
            if (this.expand.filter != null) {
                Filter filter = CompositeFilter.compact(this.expand.filter);
                for (Node root : roots) {
                    ArtifactSet.collectNodes(nodes, root, filter, this.expand.depth);
                }
            } else {
                for (Node root : roots) {
                    ArtifactSet.collectNodes(nodes, root, this.expand.depth);
                }
            }
        }
        return roots;
    }

    public Collection<Node> getNodes() {
        if (this.isReference()) {
            return this.getRef(this.getProject()).getNodes();
        }
        if (this.nodes == null) {
            this.nodes = this.computeNodes();
        }
        if (this.id != null) {
            Collection<Node> copy = this.nodes;
            this.nodes = null;
            return copy;
        }
        return this.nodes;
    }

    public Iterator<FileResource> iterator() {
        return ArtifactSet.createIterator(this.getNodes());
    }

    public static Iterator<FileResource> createIterator(Collection<Node> nodes) {
        ArrayList<FileResource> files = new ArrayList<FileResource>();
        for (Node node : nodes) {
            File file = node.getFile();
            if (file == null) continue;
            FileResource fr = new FileResource(file);
            fr.setBaseDir(file.getParentFile());
            files.add(fr);
        }
        return files.iterator();
    }

    public int size() {
        return this.getNodes().size();
    }

    public boolean isFilesystemOnly() {
        return true;
    }

    public void collectImportedNodes(Collection<Node> nodes) {
        try {
            ArtifactSetParser parser = new ArtifactSetParser(this.getProject());
            parser.parse(this.src, nodes);
        }
        catch (IOException e) {
            throw new BuildException("Failed to import artifacts file: " + this.src, (Throwable)e);
        }
    }

    public static void collectNodes(Collection<Node> nodes, Node node, Filter filter, int depth) {
        nodes.add(node);
        if (depth > 0) {
            --depth;
            for (Edge edge : node.getEdgesOut()) {
                if (!filter.accept(edge)) continue;
                ArtifactSet.collectNodes(nodes, edge.dst, filter, depth);
            }
        }
    }

    public static void collectNodes(Collection<Node> nodes, Node node, int depth) {
        nodes.add(node);
        if (depth > 0) {
            --depth;
            for (Edge edge : node.getEdgesOut()) {
                ArtifactSet.collectNodes(nodes, edge.dst, depth);
            }
        }
    }
}

