/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.resources.FileResource;
import org.nuxeo.build.maven.ArtifactDescriptor;
import org.nuxeo.build.maven.MavenClient;
import org.nuxeo.build.maven.MavenClientFactory;

public class ResolveFile
extends FileResource {
    public String key;
    public String classifier;

    public void setKey(String pattern) {
        int p = pattern.lastIndexOf(59);
        if (p > -1) {
            this.key = pattern.substring(0, p);
            this.classifier = pattern.substring(p + 1);
        } else {
            this.key = pattern;
        }
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    protected File resolveFile() throws ArtifactNotFoundException {
        MavenClient maven = MavenClientFactory.getInstance();
        ArtifactDescriptor ad = new ArtifactDescriptor(this.key);
        Artifact arti = null;
        arti = this.classifier != null ? maven.getArtifactFactory().createArtifactWithClassifier(ad.groupId, ad.artifactId, ad.version, ad.type, this.classifier) : maven.getArtifactFactory().createArtifact(ad.groupId, ad.artifactId, ad.version, ad.scope, ad.type);
        MavenClientFactory.getInstance().resolve(arti);
        return arti.getFile();
    }

    public File getFile() {
        if (this.isReference()) {
            return ((FileResource)this.getCheckedRef()).getFile();
        }
        try {
            return this.resolveFile();
        }
        catch (ArtifactNotFoundException e) {
            throw new BuildException("Failed to resolve file: " + this.key + "; classifier: " + this.classifier, (Throwable)e);
        }
    }

    public File getBaseDir() {
        return this.isReference() ? ((FileResource)this.getCheckedRef()).getBaseDir() : this.getFile().getParentFile();
    }
}

