/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.profile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.build.ant.profile.Profile;
import org.nuxeo.build.ant.profile.ProfileGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntProfileManager {
    protected Map<String, Profile> profiles = new HashMap<String, Profile>();
    protected List<ProfileGroup> groups = new ArrayList<ProfileGroup>();

    public List<String> getActiveProfiles() {
        ArrayList<String> result = new ArrayList<String>();
        for (Profile p : this.profiles.values()) {
            if (!p.isActive()) continue;
            result.add(p.getName());
        }
        return result;
    }

    public void addGroup(String[] profiles, String defaultProfile) {
        this.groups.add(new ProfileGroup(this, profiles, defaultProfile));
    }

    public void addProfile(Profile profile) {
        this.profiles.put(profile.getName(), profile);
    }

    public boolean isProfileActive(String profileName) {
        Profile profile = this.profiles.get(profileName);
        if (profile != null) {
            return profile.isActive();
        }
        return false;
    }

    public boolean isAnyProfileActive(List<String> profileNames) {
        for (String profileName : profileNames) {
            if (!this.isProfileActive(profileName)) continue;
            return true;
        }
        return false;
    }

    public void activateProfile(String profile, boolean isActive) {
        if (isActive) {
            System.out.println("Activating profile: " + profile);
        } else {
            System.out.println("Disabling profile: " + profile);
        }
        this.getOrCreateProfile(profile).setActive(isActive);
    }

    public Profile getOrCreateProfile(String profileName) {
        Profile profile = this.profiles.get(profileName);
        if (profile == null) {
            profile = new Profile(profileName);
            this.profiles.put(profileName, profile);
        }
        return profile;
    }

    public void activateProfiles(String config) {
        String[] ar;
        for (String key : ar = config.split("\\s*,\\s*")) {
            if (key.startsWith("-")) {
                this.activateProfile(key.substring(1), false);
                continue;
            }
            if (key.startsWith("+")) {
                this.activateProfile(key.substring(1), true);
                continue;
            }
            this.activateProfile(key, true);
        }
    }
}

