/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven;

import org.apache.maven.artifact.Artifact;
import org.nuxeo.build.maven.MavenClientFactory;

public class ArtifactDescriptor {
    public String groupId;
    public String artifactId;
    public String version;
    public String type = "jar";
    public String classifier;
    public String scope = "compile";

    public static ArtifactDescriptor emptyDescriptor() {
        ArtifactDescriptor ad = new ArtifactDescriptor();
        ad.scope = null;
        ad.type = null;
        return ad;
    }

    public ArtifactDescriptor() {
    }

    public ArtifactDescriptor(String groupId, String artifactId, String version, String type, String classifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.classifier = classifier;
    }

    public ArtifactDescriptor(String expr) {
        this.parse(expr);
    }

    public void parse(String expr) {
        int p = 0;
        int q = expr.indexOf(58, p);
        if (q == -1) {
            this.groupId = expr.substring(p);
            return;
        }
        this.groupId = expr.substring(p, q);
        p = q + 1;
        if ((q = expr.indexOf(58, p)) == -1) {
            this.artifactId = expr.substring(p);
            return;
        }
        this.artifactId = expr.substring(p, q);
        p = q + 1;
        if ((q = expr.indexOf(58, p)) == -1) {
            this.version = expr.substring(p);
            return;
        }
        this.version = expr.substring(p, q);
        p = q + 1;
        if ((q = expr.indexOf(58, p)) == -1) {
            this.type = expr.substring(p);
            return;
        }
        this.type = expr.substring(p, q);
        p = q + 1;
        if ((q = expr.indexOf(58, p)) == -1) {
            this.classifier = expr.substring(p);
            return;
        }
        this.classifier = expr.substring(p, q);
        p = q + 1;
        if ((q = expr.indexOf(58, p)) == -1) {
            this.scope = expr.substring(p);
            return;
        }
        this.scope = expr.substring(p, q);
    }

    public Artifact toBuildArtifact() {
        return MavenClientFactory.getInstance().getArtifactFactory().createBuildArtifact(this.groupId, this.artifactId, this.version, this.type);
    }

    public String getNodeKeyPattern() {
        if (this.groupId != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.groupId);
            if (this.artifactId != null) {
                buf.append(':').append(this.artifactId);
                if (this.version != null) {
                    buf.append(':').append(this.version);
                    if (this.type != null) {
                        buf.append(':').append(this.type);
                    }
                }
            }
            return buf.toString();
        }
        return null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.groupId).append(':').append(this.artifactId);
        if (this.version != null) {
            buf.append(':').append(this.version);
        }
        if (this.type != null) {
            buf.append(':').append(this.type);
        }
        if (this.classifier != null) {
            buf.append(':').append(this.classifier);
        }
        if (this.scope != null) {
            buf.append(':').append(this.scope);
        }
        return buf.toString();
    }
}

